/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.discovery.client.balancing;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Binding;
import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.Elements;
import com.google.inject.spi.Message;
import com.proofpoint.configuration.ConfigurationAwareProvider;
import com.proofpoint.configuration.ConfigurationFactory;
import com.proofpoint.discovery.client.ServiceSelectorConfig;
import com.proofpoint.discovery.client.balancing.HttpServiceBalancerFactory;
import com.proofpoint.discovery.client.balancing.StaticHttpServiceBalancerFactory;
import com.proofpoint.discovery.client.balancing.StaticHttpServiceConfig;
import com.proofpoint.http.client.balancing.HttpServiceBalancer;
import com.proofpoint.http.client.balancing.HttpServiceBalancerConfig;
import com.proofpoint.node.NodeInfo;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

public final class HttpServiceBalancerProvider
implements ConfigurationAwareProvider<HttpServiceBalancer> {
    private static final Key<?> STATIC_HTTP_SERVICE_BALANCER_FACTORY_KEY = Key.get(StaticHttpServiceBalancerFactory.class);
    private static final Key<?> HTTP_SERVICE_BALANCER_FACTORY_KEY = Key.get(HttpServiceBalancerFactory.class);
    private static final ImmutableSet<Key<?>> BALANCER_FACTORY_KEYS = ImmutableSet.of(STATIC_HTTP_SERVICE_BALANCER_FACTORY_KEY, HTTP_SERVICE_BALANCER_FACTORY_KEY);
    private final String type;
    private ConfigurationFactory configurationFactory;
    private StaticHttpServiceBalancerFactory staticServiceBalancerFactory;
    private HttpServiceBalancerFactory serviceBalancerFactory;
    private NodeInfo nodeInfo;

    public HttpServiceBalancerProvider(String type) {
        Objects.requireNonNull(type, "type is null");
        this.type = type;
    }

    @Inject
    public void setConfigurationFactory(ConfigurationFactory configurationFactory) {
        this.configurationFactory = configurationFactory;
    }

    public void buildConfigObjects(Iterable<? extends Module> modules) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Element element : Elements.getElements(modules)) {
            Collection factoryKey = (Collection)element.acceptVisitor((ElementVisitor)new DefaultElementVisitor<Collection<Key<?>>>(){

                public <T> Collection<Key<?>> visit(Binding<T> binding) {
                    Key key = binding.getKey();
                    return Sets.filter((Set)BALANCER_FACTORY_KEYS, k -> k.equals((Object)key));
                }
            });
            builder.addAll((Iterable)MoreObjects.firstNonNull((Object)factoryKey, (Object)ImmutableList.of()));
        }
        ImmutableSet factoryKeys = builder.build();
        this.configurationFactory.build(HttpServiceBalancerConfig.class, "service-balancer." + this.type);
        if (factoryKeys.size() > 1) {
            throw new ConfigurationException((Iterable)ImmutableSet.of((Object)new Message("Multiple HttpServiceBalancer factories bound: " + factoryKeys)));
        }
        if (factoryKeys.contains(STATIC_HTTP_SERVICE_BALANCER_FACTORY_KEY)) {
            this.configurationFactory.build(StaticHttpServiceConfig.class, "service-balancer." + this.type);
        } else if (factoryKeys.contains(HTTP_SERVICE_BALANCER_FACTORY_KEY)) {
            this.configurationFactory.build(ServiceSelectorConfig.class, "discovery." + this.type);
        } else {
            throw new ConfigurationException((Iterable)ImmutableSet.of((Object)new Message("Could not find a factory for HttpServiceBalancer")));
        }
    }

    @Inject(optional=true)
    public void setStaticServiceBalancerFactory(StaticHttpServiceBalancerFactory staticServiceBalancerFactory) {
        Objects.requireNonNull(staticServiceBalancerFactory, "staticServiceBalancerFactory is null");
        this.staticServiceBalancerFactory = staticServiceBalancerFactory;
    }

    @Inject(optional=true)
    public void setServiceBalancerFactory(HttpServiceBalancerFactory serviceBalancerFactory, NodeInfo nodeInfo) {
        Objects.requireNonNull(serviceBalancerFactory, "serviceBalancerFactory is null");
        Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        this.serviceBalancerFactory = serviceBalancerFactory;
        this.nodeInfo = nodeInfo;
    }

    public HttpServiceBalancer get() {
        HttpServiceBalancerConfig balancerConfig = (HttpServiceBalancerConfig)this.configurationFactory.build(HttpServiceBalancerConfig.class, "service-balancer." + this.type);
        if (this.staticServiceBalancerFactory != null) {
            StaticHttpServiceConfig staticHttpServiceConfig = (StaticHttpServiceConfig)this.configurationFactory.build(StaticHttpServiceConfig.class, "service-balancer." + this.type);
            return this.staticServiceBalancerFactory.createHttpServiceBalancer(this.type, staticHttpServiceConfig, balancerConfig);
        }
        Objects.requireNonNull(this.serviceBalancerFactory, "serviceBalancerFactory is null");
        Objects.requireNonNull(this.nodeInfo, "nodeInfo is null");
        ServiceSelectorConfig selectorConfig = (ServiceSelectorConfig)this.configurationFactory.build(ServiceSelectorConfig.class, "discovery." + this.type);
        return this.serviceBalancerFactory.createHttpServiceBalancer(this.type, selectorConfig, balancerConfig, this.nodeInfo);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpServiceBalancerProvider that = (HttpServiceBalancerProvider)o;
        return Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.type);
    }
}

