/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.discovery.client.balancing;

import com.google.common.collect.ImmutableMap;
import com.proofpoint.discovery.client.balancing.StaticHttpServiceConfig;
import com.proofpoint.http.client.balancing.HttpServiceBalancer;
import com.proofpoint.http.client.balancing.HttpServiceBalancerConfig;
import com.proofpoint.http.client.balancing.HttpServiceBalancerImpl;
import com.proofpoint.http.client.balancing.HttpServiceBalancerStats;
import com.proofpoint.reporting.ReportCollectionFactory;
import com.proofpoint.reporting.ReportExporter;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;

public class StaticHttpServiceBalancerFactory {
    private final ReportExporter reportExporter;
    private final ReportCollectionFactory reportCollectionFactory;

    @Inject
    public StaticHttpServiceBalancerFactory(ReportExporter reportExporter, ReportCollectionFactory reportCollectionFactory) {
        this.reportExporter = Objects.requireNonNull(reportExporter, "reportExporter is null");
        this.reportCollectionFactory = Objects.requireNonNull(reportCollectionFactory, "reportCollectionFactory is null");
    }

    HttpServiceBalancer createHttpServiceBalancer(String type, StaticHttpServiceConfig staticHttpServiceConfig, HttpServiceBalancerConfig balancerConfig) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(balancerConfig, "balancerConfig is null");
        ImmutableMap tags = ImmutableMap.of((Object)"serviceType", (Object)type);
        HttpServiceBalancerStats httpServiceBalancerStats = (HttpServiceBalancerStats)this.reportCollectionFactory.createReportCollection(HttpServiceBalancerStats.class, false, "ServiceClient", (Map)tags);
        HttpServiceBalancerImpl balancer = new HttpServiceBalancerImpl(String.format("type=[%s]", type), httpServiceBalancerStats, balancerConfig);
        balancer.updateHttpUris((Collection)((Object)staticHttpServiceConfig.getUris()));
        this.reportExporter.export((Object)balancer, false, "ServiceClient", (Map)tags);
        return balancer;
    }
}

