/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.discovery.client.balancing;

import com.google.common.collect.ForwardingMultiset;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import com.proofpoint.configuration.Config;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;

public class StaticHttpServiceConfig {
    private UriMultiset uris = UriMultiset.of(new URI[0]);

    public UriMultiset getUris() {
        return this.uris;
    }

    @Config(value="uri")
    public StaticHttpServiceConfig setUris(UriMultiset uris) {
        this.uris = uris;
        return this;
    }

    public static final class UriMultiset
    extends ForwardingMultiset<URI> {
        private final Multiset<URI> delegate;

        private UriMultiset(Collection<URI> delegate) {
            this.delegate = ImmutableMultiset.copyOf(delegate);
        }

        public static UriMultiset of(URI ... uris) {
            return new UriMultiset((Collection<URI>)ImmutableMultiset.copyOf((Object[])uris));
        }

        public static UriMultiset valueOf(String string) {
            ImmutableMultiset uris = (ImmutableMultiset)Arrays.stream(string.split("\\s*,\\s*")).map(URI::create).collect(ImmutableMultiset.toImmutableMultiset());
            return new UriMultiset((Collection<URI>)uris);
        }

        protected Multiset<URI> delegate() {
            return this.delegate;
        }
    }
}

