/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.discovery.client.testing;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.proofpoint.concurrent.MoreFutures;
import com.proofpoint.discovery.client.DiscoveryException;
import com.proofpoint.discovery.client.DiscoveryLookupClient;
import com.proofpoint.discovery.client.ServiceDescriptor;
import com.proofpoint.discovery.client.ServiceDescriptors;
import com.proofpoint.discovery.client.ServiceSelector;
import com.proofpoint.discovery.client.ServiceSelectorConfig;
import com.proofpoint.log.Logger;
import com.proofpoint.node.NodeInfo;
import java.util.List;
import java.util.Objects;

public class SimpleServiceSelector
implements ServiceSelector {
    private static final Logger log = Logger.get(SimpleServiceSelector.class);
    private final String type;
    private final String pool;
    private final DiscoveryLookupClient lookupClient;

    public SimpleServiceSelector(String type, ServiceSelectorConfig selectorConfig, NodeInfo nodeInfo, DiscoveryLookupClient lookupClient) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(selectorConfig, "selectorConfig is null");
        Objects.requireNonNull(lookupClient, "client is null");
        this.type = type;
        this.pool = (String)MoreObjects.firstNonNull((Object)selectorConfig.getPool(), (Object)nodeInfo.getPool());
        this.lookupClient = lookupClient;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getPool() {
        return this.pool;
    }

    @Override
    public List<ServiceDescriptor> selectAllServices() {
        try {
            ListenableFuture<ServiceDescriptors> future = this.lookupClient.getServices(this.type, this.pool);
            ServiceDescriptors serviceDescriptors = (ServiceDescriptors)MoreFutures.getFutureValue(future, DiscoveryException.class);
            return serviceDescriptors.getServiceDescriptors();
        }
        catch (DiscoveryException e) {
            log.error((Throwable)e);
            return ImmutableList.of();
        }
    }
}

