/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.discovery.client.testing;

import com.proofpoint.discovery.client.DiscoveryLookupClient;
import com.proofpoint.discovery.client.ServiceSelector;
import com.proofpoint.discovery.client.ServiceSelectorConfig;
import com.proofpoint.discovery.client.ServiceSelectorFactory;
import com.proofpoint.discovery.client.testing.SimpleServiceSelector;
import com.proofpoint.node.NodeInfo;
import java.util.Objects;
import javax.inject.Inject;

public class SimpleServiceSelectorFactory
implements ServiceSelectorFactory {
    private final DiscoveryLookupClient lookupClient;
    private final NodeInfo nodeInfo;

    @Inject
    public SimpleServiceSelectorFactory(DiscoveryLookupClient lookupClient, NodeInfo nodeInfo) {
        Objects.requireNonNull(lookupClient, "client is null");
        Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        this.lookupClient = lookupClient;
        this.nodeInfo = nodeInfo;
    }

    @Override
    public ServiceSelector createServiceSelector(String type, ServiceSelectorConfig selectorConfig) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(selectorConfig, "selectorConfig is null");
        return new SimpleServiceSelector(type, selectorConfig, this.nodeInfo, this.lookupClient);
    }
}

