/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.discovery.client.testing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.proofpoint.discovery.client.ServiceDescriptor;
import com.proofpoint.discovery.client.ServiceSelector;
import java.util.List;
import java.util.Objects;

public class StaticServiceSelector
implements ServiceSelector {
    private final String type;
    private final String pool;
    private final List<ServiceDescriptor> serviceDescriptors;

    public StaticServiceSelector(ServiceDescriptor ... serviceDescriptors) {
        this((Iterable<ServiceDescriptor>)ImmutableList.copyOf((Object[])serviceDescriptors));
    }

    public StaticServiceSelector(Iterable<ServiceDescriptor> serviceDescriptors) {
        Objects.requireNonNull(serviceDescriptors, "serviceDescriptors is null");
        ServiceDescriptor serviceDescriptor = (ServiceDescriptor)Iterables.getFirst(serviceDescriptors, null);
        if (serviceDescriptor != null) {
            this.type = serviceDescriptor.getType();
            this.pool = serviceDescriptor.getPool();
        } else {
            this.type = "unknown";
            this.pool = "general";
        }
        for (ServiceDescriptor descriptor : serviceDescriptors) {
            Preconditions.checkArgument((boolean)descriptor.getType().equals(this.type));
            Preconditions.checkArgument((boolean)descriptor.getPool().equals(this.pool));
        }
        this.serviceDescriptors = ImmutableList.copyOf(serviceDescriptors);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getPool() {
        return this.pool;
    }

    @Override
    public List<ServiceDescriptor> selectAllServices() {
        return this.serviceDescriptors;
    }
}

