/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.reporting;

import com.google.inject.Inject;
import com.proofpoint.stats.CounterStat;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.annotation.PreDestroy;
import org.weakref.jmx.Nested;

class LogCounter {
    private static final Logger ROOT = Logger.getLogger("");
    private final CounterStat logErrors = new CounterStat();
    private final Handler handler = new Handler(){

        @Override
        public void publish(LogRecord record) {
            if (record.getLevel().intValue() >= Level.SEVERE.intValue()) {
                LogCounter.this.logErrors.add(1L);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    };

    @Inject
    LogCounter() {
        ROOT.addHandler(this.handler);
    }

    @Nested
    public CounterStat getLogErrors() {
        return this.logErrors;
    }

    @PreDestroy
    public void close() {
        ROOT.removeHandler(this.handler);
    }
}

