/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.stats;

import com.proofpoint.reporting.Bucketed;
import com.proofpoint.reporting.Reported;
import com.proofpoint.stats.QuantileDigest;
import javax.annotation.concurrent.GuardedBy;

public final class BucketedTimeDistribution
extends Bucketed<Distribution> {
    public void add(long value) {
        this.applyToCurrentBucket(input -> {
            Distribution distribution = input;
            synchronized (distribution) {
                ((Distribution)input).digest.add(value);
                Distribution distribution2 = input;
                distribution2.total = distribution2.total + value;
            }
            return null;
        });
    }

    protected Distribution createBucket(Distribution previousBucket) {
        return new Distribution();
    }

    protected static class Distribution {
        private static final double MAX_ERROR = 0.01;
        @GuardedBy(value="this")
        private final QuantileDigest digest = new QuantileDigest(0.01);
        @GuardedBy(value="this")
        private long total = 0L;

        protected Distribution() {
        }

        @Reported
        public synchronized double getCount() {
            return this.digest.getCount();
        }

        @Reported
        public synchronized double getTotal() {
            return Distribution.convertToSeconds(this.total);
        }

        @Reported
        public synchronized double getP50() {
            return Distribution.convertToSeconds(this.digest.getQuantile(0.5));
        }

        @Reported
        public synchronized double getP75() {
            return Distribution.convertToSeconds(this.digest.getQuantile(0.75));
        }

        @Reported
        public synchronized double getP90() {
            return Distribution.convertToSeconds(this.digest.getQuantile(0.9));
        }

        @Reported
        public synchronized double getP95() {
            return Distribution.convertToSeconds(this.digest.getQuantile(0.95));
        }

        @Reported
        public synchronized double getP99() {
            return Distribution.convertToSeconds(this.digest.getQuantile(0.99));
        }

        @Reported
        public synchronized double getMin() {
            return Distribution.convertToSeconds(this.digest.getMin());
        }

        @Reported
        public synchronized double getMax() {
            return Distribution.convertToSeconds(this.digest.getMax());
        }

        private static double convertToSeconds(long nanos) {
            if (nanos == Long.MAX_VALUE || nanos == Long.MIN_VALUE) {
                return Double.NaN;
            }
            return (double)nanos * 1.0E-9;
        }
    }
}

