/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.stats;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.proofpoint.stats.BucketedDistribution;
import com.proofpoint.stats.Distribution;
import com.proofpoint.stats.ExponentialDecay;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Nested;

public class DistributionStat {
    private final Distribution oneMinute;
    private final Distribution fiveMinutes;
    private final Distribution fifteenMinutes;
    private final Distribution allTime;
    private final BucketedDistribution bucket = new BucketedDistribution();

    public DistributionStat() {
        this.oneMinute = new Distribution(ExponentialDecay.oneMinute());
        this.fiveMinutes = new Distribution(ExponentialDecay.fiveMinutes());
        this.fifteenMinutes = new Distribution(ExponentialDecay.fifteenMinutes());
        this.allTime = new Distribution();
    }

    public void add(long value) {
        this.oneMinute.add(value);
        this.fiveMinutes.add(value);
        this.fifteenMinutes.add(value);
        this.allTime.add(value);
        this.bucket.add(value);
    }

    @Nested
    public Distribution getOneMinute() {
        return this.oneMinute;
    }

    @Nested
    public Distribution getFiveMinutes() {
        return this.fiveMinutes;
    }

    @Nested
    public Distribution getFifteenMinutes() {
        return this.fifteenMinutes;
    }

    @Nested
    public Distribution getAllTime() {
        return this.allTime;
    }

    @Flatten
    public BucketedDistribution getBucket() {
        return this.bucket;
    }

    public DistributionStatSnapshot snapshot() {
        return new DistributionStatSnapshot(this.getOneMinute().snapshot(), this.getFiveMinutes().snapshot(), this.getFifteenMinutes().snapshot(), this.getAllTime().snapshot());
    }

    public static class DistributionStatSnapshot {
        private final Distribution.DistributionSnapshot oneMinute;
        private final Distribution.DistributionSnapshot fiveMinute;
        private final Distribution.DistributionSnapshot fifteenMinute;
        private final Distribution.DistributionSnapshot allTime;

        @JsonCreator
        public DistributionStatSnapshot(@JsonProperty(value="oneMinute") Distribution.DistributionSnapshot oneMinute, @JsonProperty(value="fiveMinute") Distribution.DistributionSnapshot fiveMinute, @JsonProperty(value="fifteenMinute") Distribution.DistributionSnapshot fifteenMinute, @JsonProperty(value="allTime") Distribution.DistributionSnapshot allTime) {
            this.oneMinute = oneMinute;
            this.fiveMinute = fiveMinute;
            this.fifteenMinute = fifteenMinute;
            this.allTime = allTime;
        }

        @JsonProperty
        public Distribution.DistributionSnapshot getOneMinute() {
            return this.oneMinute;
        }

        @JsonProperty
        public Distribution.DistributionSnapshot getFiveMinutes() {
            return this.fiveMinute;
        }

        @JsonProperty
        public Distribution.DistributionSnapshot getFifteenMinutes() {
            return this.fifteenMinute;
        }

        @JsonProperty
        public Distribution.DistributionSnapshot getAllTime() {
            return this.allTime;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("oneMinute", (Object)this.oneMinute).add("fiveMinute", (Object)this.fiveMinute).add("fifteenMinute", (Object)this.fifteenMinute).add("allTime", (Object)this.allTime).toString();
        }
    }
}

