/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.stats;

import com.proofpoint.reporting.Bucketed;
import com.proofpoint.reporting.Reported;
import com.proofpoint.stats.QuantileDigest;
import javax.annotation.concurrent.GuardedBy;

public class SparseDistributionStat
extends Bucketed<Distribution> {
    public void add(long value) {
        this.applyToCurrentBucket(input -> {
            Distribution distribution = input;
            synchronized (distribution) {
                ((Distribution)input).digest.add(value);
                Distribution distribution2 = input;
                distribution2.total = distribution2.total + value;
            }
            return null;
        });
    }

    protected final Distribution createBucket(Distribution previousBucket) {
        return new Distribution();
    }

    protected static class Distribution {
        private static final double MAX_ERROR = 0.01;
        @GuardedBy(value="this")
        private final QuantileDigest digest = new QuantileDigest(0.01);
        @GuardedBy(value="this")
        private long total = 0L;

        protected Distribution() {
        }

        @Reported
        public synchronized double getCount() {
            double count = this.digest.getCount();
            if (count == 0.0) {
                return Double.NaN;
            }
            return count;
        }

        @Reported
        public synchronized long getTotal() {
            if (this.digest.getCount() == 0.0) {
                return Long.MIN_VALUE;
            }
            return this.total;
        }

        @Reported
        public synchronized long getP50() {
            return this.digest.getQuantile(0.5);
        }

        @Reported
        public synchronized long getP75() {
            return this.digest.getQuantile(0.75);
        }

        @Reported
        public synchronized long getP90() {
            return this.digest.getQuantile(0.9);
        }

        @Reported
        public synchronized long getP95() {
            return this.digest.getQuantile(0.95);
        }

        @Reported
        public synchronized long getP99() {
            return this.digest.getQuantile(0.99);
        }

        @Reported
        public synchronized long getMin() {
            return this.digest.getMin();
        }

        @Reported
        public synchronized long getMax() {
            return this.digest.getMax();
        }
    }
}

