/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.platform.sample;

import com.google.common.base.Ticker;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.proofpoint.configuration.ConfigBinder;
import com.proofpoint.discovery.client.DiscoveryBinder;
import com.proofpoint.jaxrs.JaxrsBinder;
import com.proofpoint.platform.sample.PersonResource;
import com.proofpoint.platform.sample.PersonStore;
import com.proofpoint.platform.sample.PersonsResource;
import com.proofpoint.platform.sample.StoreConfig;
import com.proofpoint.reporting.HealthBinder;
import com.proofpoint.reporting.ReportBinder;

public class MainModule
implements Module {
    @Override
    public void configure(Binder binder) {
        binder.disableCircularProxies();
        binder.bind(PersonStore.class).in(Scopes.SINGLETON);
        ReportBinder.reportBinder((Binder)binder).export(PersonStore.class).withApplicationPrefix();
        HealthBinder.healthBinder((Binder)binder).export(PersonStore.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(PersonsResource.class).withApplicationPrefix();
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(PersonResource.class).withApplicationPrefix();
        ConfigBinder.bindConfig((Binder)binder).bind(StoreConfig.class);
        DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpAnnouncement("person");
    }

    @Provides
    static Ticker createTicker() {
        return Ticker.systemTicker();
    }
}

