/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.platform.sample;

import com.proofpoint.platform.sample.Person;
import com.proofpoint.platform.sample.PersonRepresentation;
import com.proofpoint.platform.sample.PersonStore;
import java.net.URI;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1/person/{id: \\w+}")
public class PersonResource {
    private final PersonStore store;

    @Inject
    public PersonResource(PersonStore store) {
        this.store = Objects.requireNonNull(store, "store must not be null");
    }

    @GET
    @Produces(value={"application/json"})
    public Response get(@PathParam(value="id") String id, @Context UriInfo uriInfo) {
        Objects.requireNonNull(id, "id must not be null");
        Person person = this.store.get(id);
        if (person == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("[" + id + "]")).build();
        }
        return Response.ok((Object)person).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response put(@PathParam(value="id") String id, PersonRepresentation person) {
        Objects.requireNonNull(id, "id must not be null");
        Objects.requireNonNull(person, "person must not be null");
        boolean added = this.store.put(id, person.toPerson());
        if (added) {
            UriBuilder uri = UriBuilder.fromResource(PersonResource.class);
            return Response.created((URI)uri.build(new Object[]{id})).build();
        }
        return Response.noContent().build();
    }

    @DELETE
    public Response delete(@PathParam(value="id") String id) {
        Objects.requireNonNull(id, "id must not be null");
        if (!this.store.delete(id)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.noContent().build();
    }
}

