/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.platform.sample;

import com.google.auto.value.AutoValue;
import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.proofpoint.platform.sample.AutoValue_PersonStore_StoreEntry;
import com.proofpoint.platform.sample.Person;
import com.proofpoint.platform.sample.PersonStoreStats;
import com.proofpoint.platform.sample.StoreConfig;
import com.proofpoint.reporting.Gauge;
import com.proofpoint.reporting.HealthCheck;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.weakref.jmx.Flatten;

public class PersonStore {
    private final ConcurrentMap<String, Person> persons;
    private final PersonStoreStats stats;

    @Inject
    public PersonStore(StoreConfig config, Ticker ticker) {
        Objects.requireNonNull(config, "config must not be null");
        Cache personCache = CacheBuilder.newBuilder().expireAfterWrite(config.getTtl().toMillis(), TimeUnit.MILLISECONDS).ticker(ticker).build();
        this.persons = personCache.asMap();
        this.stats = new PersonStoreStats();
    }

    @Flatten
    public PersonStoreStats getStats() {
        return this.stats;
    }

    @Gauge
    private int getSize() {
        return this.persons.size();
    }

    @HealthCheck(value="Person store size")
    private String checkSize() {
        int size = this.persons.size();
        if (size < 2) {
            return "Not enough persons in store: " + size;
        }
        return null;
    }

    public Person get(String id) {
        Objects.requireNonNull(id, "id must not be null");
        Person person = (Person)this.persons.get(id);
        if (person != null) {
            this.stats.personFetched();
        }
        return person;
    }

    public boolean put(String id, Person person) {
        boolean added;
        Objects.requireNonNull(id, "id must not be null");
        Objects.requireNonNull(person, "person must not be null");
        boolean bl = added = this.persons.put(id, person) == null;
        if (added) {
            this.stats.personAdded();
        } else {
            this.stats.personUpdated();
        }
        return added;
    }

    public boolean delete(String id) {
        Objects.requireNonNull(id, "id must not be null");
        Person removedPerson = (Person)this.persons.remove(id);
        if (removedPerson != null) {
            this.stats.personRemoved();
        }
        return removedPerson != null;
    }

    public Collection<StoreEntry> getAll() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry entry : this.persons.entrySet()) {
            builder.add((Object)new AutoValue_PersonStore_StoreEntry((String)entry.getKey(), (Person)entry.getValue()));
        }
        return builder.build();
    }

    @AutoValue
    public static abstract class StoreEntry {
        public abstract String getId();

        public abstract Person getPerson();
    }
}

