/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.platform.sample;

import com.google.common.collect.ImmutableMap;
import com.proofpoint.platform.sample.Person;
import com.proofpoint.platform.sample.PersonStore;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/v1/person")
public class PersonsResource {
    private final PersonStore store;

    @Inject
    public PersonsResource(PersonStore store) {
        this.store = Objects.requireNonNull(store, "store must not be null");
    }

    @GET
    @Produces(value={"application/json"})
    public Map<String, Person> listAll() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (PersonStore.StoreEntry entry : this.store.getAll()) {
            builder.put((Object)entry.getId(), (Object)entry.getPerson());
        }
        return builder.build();
    }
}

