/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.bootstrap;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.ConfigurationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.spi.Message;
import com.proofpoint.bootstrap.ColumnPrinter;
import com.proofpoint.bootstrap.DynamicApplicationNameModule;
import com.proofpoint.bootstrap.LifeCycleManager;
import com.proofpoint.bootstrap.LifeCycleModule;
import com.proofpoint.bootstrap.LoggingWriter;
import com.proofpoint.bootstrap.QuietMode;
import com.proofpoint.configuration.ConfigurationAwareModule;
import com.proofpoint.configuration.ConfigurationDefaultingModule;
import com.proofpoint.configuration.ConfigurationFactory;
import com.proofpoint.configuration.ConfigurationFactoryBuilder;
import com.proofpoint.configuration.ConfigurationInspector;
import com.proofpoint.configuration.ConfigurationModule;
import com.proofpoint.configuration.ConfigurationValidator;
import com.proofpoint.configuration.ValidationErrorModule;
import com.proofpoint.configuration.WarningsMonitor;
import com.proofpoint.log.Logger;
import com.proofpoint.log.Logging;
import com.proofpoint.log.LoggingConfiguration;
import com.proofpoint.node.ApplicationNameModule;
import com.proofpoint.node.NodeInfo;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;

public class Bootstrap {
    private final Logger log = Logger.get((String)"Bootstrap");
    private final Logging logging;
    private final List<Module> modules;
    private Map<String, String> requiredConfigurationProperties = null;
    private Map<String, String> applicationDefaults = null;
    private boolean quiet = false;
    private boolean requireExplicitBindings = true;
    private boolean initialized = false;

    public static BootstrapBeforeModules bootstrapApplication(String applicationName) {
        return new StaticBootstrapBeforeModules(applicationName);
    }

    public static <T> BootstrapBeforeModules bootstrapApplication(Class<T> configClass, Function<T, String> applicationNameFunction) {
        return new DynamicBootstrapBeforeModules(configClass, applicationNameFunction);
    }

    public static UnitTestBootstrapBeforeModules bootstrapTest() {
        return new UnitTestBootstrapBeforeModules();
    }

    private Bootstrap(Module applicationNameModule, Iterable<? extends Module> modules, boolean initializeLogging) {
        if (initializeLogging) {
            this.logging = Logging.initialize();
            Thread.setDefaultUncaughtExceptionHandler((t, e) -> this.log.error(e, "Uncaught exception in thread %s", new Object[]{t.getName()}));
        } else {
            this.logging = null;
        }
        this.modules = ImmutableList.builder().add((Object)Objects.requireNonNull(applicationNameModule, "applicationNameModule is null")).add((Object)new LifeCycleModule()).addAll(modules).build();
    }

    @Deprecated
    public Bootstrap setRequiredConfigurationProperty(String key, String value) {
        if (this.requiredConfigurationProperties == null) {
            this.requiredConfigurationProperties = new TreeMap<String, String>();
        }
        this.requiredConfigurationProperties.put(key, value);
        return this;
    }

    @Deprecated
    public Bootstrap setRequiredConfigurationProperties(Map<String, String> requiredConfigurationProperties) {
        if (this.requiredConfigurationProperties == null) {
            this.requiredConfigurationProperties = new TreeMap<String, String>();
        }
        this.requiredConfigurationProperties.putAll(requiredConfigurationProperties);
        return this;
    }

    public Bootstrap withApplicationDefaults(Map<String, String> applicationDefaults) {
        Preconditions.checkState((this.applicationDefaults == null ? 1 : 0) != 0, (Object)"applicationDefaults already specified");
        this.applicationDefaults = Objects.requireNonNull(applicationDefaults, "applicationDefaults is null");
        return this;
    }

    public Bootstrap quiet() {
        this.quiet = true;
        return this;
    }

    public Bootstrap requireExplicitBindings(boolean requireExplicitBindings) {
        this.requireExplicitBindings = requireExplicitBindings;
        return this;
    }

    public Injector initialize() throws Exception {
        LifeCycleManager lifeCycleManager;
        Preconditions.checkState((!this.initialized ? 1 : 0) != 0, (Object)"Already initialized");
        this.initialized = true;
        HashMap moduleDefaults = new HashMap();
        HashMap moduleDefaultSource = new HashMap();
        ArrayList<Message> moduleDefaultErrors = new ArrayList<Message>();
        for (Module module2 : this.modules) {
            if (!(module2 instanceof ConfigurationDefaultingModule)) continue;
            ConfigurationDefaultingModule configurationDefaultingModule = (ConfigurationDefaultingModule)module2;
            Map defaults = configurationDefaultingModule.getConfigurationDefaults();
            for (Map.Entry entry : defaults.entrySet()) {
                ConfigurationDefaultingModule oldModule = moduleDefaultSource.put(entry.getKey(), configurationDefaultingModule);
                if (oldModule != null) {
                    moduleDefaultErrors.add(new Message((Object)module2, "Configuration default for \"" + (String)entry.getKey() + "\" set by both " + oldModule.toString() + " and " + module2.toString()));
                }
                moduleDefaults.put(entry.getKey(), entry.getValue());
            }
        }
        ConfigurationFactoryBuilder builder = new ConfigurationFactoryBuilder();
        if (!moduleDefaults.isEmpty()) {
            builder = builder.withModuleDefaults(moduleDefaults, moduleDefaultSource);
        }
        if (this.applicationDefaults != null) {
            builder = builder.withApplicationDefaults(this.applicationDefaults);
        }
        if (this.requiredConfigurationProperties == null) {
            this.log.info("Loading configuration", new Object[0]);
            builder = builder.withFile(System.getProperty("config")).withFile(System.getProperty("secrets-config")).withSystemProperties();
        } else {
            builder = builder.withRequiredProperties(this.requiredConfigurationProperties);
        }
        WarningLoggingMonitor warningsMonitor = new WarningLoggingMonitor();
        builder = builder.withWarningsMonitor((WarningsMonitor)warningsMonitor);
        ConfigurationFactory configurationFactory = builder.build();
        if (this.logging != null) {
            this.log.info("Initializing logging", new Object[0]);
            LoggingConfiguration configuration = (LoggingConfiguration)configurationFactory.build(LoggingConfiguration.class);
            this.logging.configure(configuration);
        }
        warningsMonitor.loggingInitialized();
        this.modules.stream().filter(ConfigurationAwareModule.class::isInstance).map(ConfigurationAwareModule.class::cast).forEach(module -> module.setConfigurationFactory(configurationFactory));
        ConfigurationValidator configurationValidator = new ConfigurationValidator(configurationFactory);
        List messages = configurationValidator.validate(this.modules);
        if (!this.quiet) {
            this.logConfiguration(configurationFactory);
        }
        ImmutableList.Builder moduleList = ImmutableList.builder();
        moduleList.add((Object)new ConfigurationModule(configurationFactory));
        if (!moduleDefaultErrors.isEmpty()) {
            moduleList.add((Object)new ValidationErrorModule(moduleDefaultErrors));
        }
        if (!messages.isEmpty()) {
            moduleList.add((Object)new ValidationErrorModule(messages));
        }
        moduleList.add(binder -> binder.bind(WarningsMonitor.class).toInstance((Object)warningsMonitor));
        moduleList.add(binder -> binder.bindConstant().annotatedWith(QuietMode.class).to(this.quiet));
        moduleList.add(Binder::disableCircularProxies);
        if (this.requireExplicitBindings) {
            moduleList.add(Binder::requireExplicitBindings);
        }
        moduleList.addAll(this.modules);
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Iterable)moduleList.build());
        if (!this.quiet) {
            try {
                NodeInfo nodeInfo = (NodeInfo)injector.getInstance(NodeInfo.class);
                this.log.info("Node ID %s", new Object[]{nodeInfo.getNodeId()});
            }
            catch (ConfigurationException nodeInfo) {
                // empty catch block
            }
        }
        if ((lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class)).size() > 0) {
            lifeCycleManager.start();
        }
        return injector;
    }

    private void logConfiguration(ConfigurationFactory configurationFactory) {
        ColumnPrinter columnPrinter = Bootstrap.makePrinterForConfiguration(configurationFactory);
        try (PrintWriter out = new PrintWriter(new LoggingWriter(this.log));){
            columnPrinter.print(out);
        }
    }

    private static ColumnPrinter makePrinterForConfiguration(ConfigurationFactory configurationFactory) {
        ConfigurationInspector configurationInspector = new ConfigurationInspector();
        ColumnPrinter columnPrinter = new ColumnPrinter("PROPERTY", "DEFAULT", "RUNTIME", "DESCRIPTION");
        TreeSet attributes = new TreeSet((o1, o2) -> o1.getPropertyName().compareTo(o2.getPropertyName()));
        for (ConfigurationInspector.ConfigRecord record : configurationInspector.inspect(configurationFactory)) {
            attributes.addAll(record.getAttributes());
        }
        for (ConfigurationInspector.ConfigAttribute attribute : attributes) {
            columnPrinter.addValues(attribute.getPropertyName(), attribute.getDefaultValue(), attribute.getCurrentValue(), attribute.getDescription());
        }
        return columnPrinter;
    }

    private class WarningLoggingMonitor
    implements WarningsMonitor {
        private final AtomicBoolean loggingInitialized = new AtomicBoolean();
        private final List<String> warnings = new ArrayList<String>();

        private WarningLoggingMonitor() {
        }

        public void onWarning(String message) {
            if (this.loggingInitialized.get()) {
                Bootstrap.this.log.warn(message, new Object[0]);
            } else {
                this.warnings.add(message);
            }
        }

        public void loggingInitialized() {
            this.loggingInitialized.set(true);
            for (String warning : this.warnings) {
                this.onWarning(warning);
            }
            this.warnings.clear();
        }
    }

    public static class UnitTestBootstrap {
        private Bootstrap bootstrap;

        private UnitTestBootstrap(Iterable<? extends Module> modules) {
            this.bootstrap = new Bootstrap((Module)new ApplicationNameModule("test-application"), modules, false).quiet().setRequiredConfigurationProperties((Map<String, String>)ImmutableMap.of());
        }

        public UnitTestBootstrap setRequiredConfigurationProperty(String key, String value) {
            this.bootstrap = this.bootstrap.setRequiredConfigurationProperty(key, value);
            return this;
        }

        public UnitTestBootstrap setRequiredConfigurationProperties(Map<String, String> requiredConfigurationProperties) {
            this.bootstrap = this.bootstrap.setRequiredConfigurationProperties(requiredConfigurationProperties);
            return this;
        }

        public UnitTestBootstrap withApplicationDefaults(Map<String, String> applicationDefaults) {
            this.bootstrap = this.bootstrap.withApplicationDefaults(applicationDefaults);
            return this;
        }

        public UnitTestBootstrap requireExplicitBindings(boolean requireExplicitBindings) {
            this.bootstrap = this.bootstrap.requireExplicitBindings(requireExplicitBindings);
            return this;
        }

        public Injector initialize() throws Exception {
            return this.bootstrap.initialize();
        }
    }

    public static class UnitTestBootstrapBeforeModules {
        private UnitTestBootstrapBeforeModules() {
        }

        public UnitTestBootstrap withModules(Iterable<? extends Module> modules) {
            return new UnitTestBootstrap(modules);
        }

        public UnitTestBootstrap withModules(Module ... modules) {
            return this.withModules((Iterable<? extends Module>)ImmutableList.copyOf((Object[])modules));
        }
    }

    private static class DynamicBootstrapBeforeModules<T>
    extends BootstrapBeforeModules {
        private final Class<T> configClass;
        private final Function<T, String> applicationNameFunction;

        private DynamicBootstrapBeforeModules(Class<T> configClass, Function<T, String> applicationNameFunction) {
            this.configClass = Objects.requireNonNull(configClass, "configClass is null");
            this.applicationNameFunction = Objects.requireNonNull(applicationNameFunction, "applicationNameFunction is null");
        }

        @Override
        public Bootstrap withModules(Iterable<? extends Module> modules) {
            return new Bootstrap((Module)new DynamicApplicationNameModule<T>(this.configClass, this.applicationNameFunction), modules, this.initializeLogging);
        }
    }

    private static class StaticBootstrapBeforeModules
    extends BootstrapBeforeModules {
        private final String applicationName;

        private StaticBootstrapBeforeModules(String applicationName) {
            this.applicationName = Objects.requireNonNull(applicationName, "applicationName is null");
        }

        @Override
        public Bootstrap withModules(Iterable<? extends Module> modules) {
            return new Bootstrap((Module)new ApplicationNameModule(this.applicationName), modules, this.initializeLogging);
        }
    }

    public static abstract class BootstrapBeforeModules {
        boolean initializeLogging = true;

        private BootstrapBeforeModules() {
        }

        public BootstrapBeforeModules doNotInitializeLogging() {
            this.initializeLogging = false;
            return this;
        }

        public Bootstrap withModules(Module ... modules) {
            return this.withModules((Iterable<? extends Module>)ImmutableList.copyOf((Object[])modules));
        }

        public abstract Bootstrap withModules(Iterable<? extends Module> var1);
    }
}

