/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.bootstrap;

import com.google.common.collect.Lists;
import com.proofpoint.bootstrap.AcceptRequests;
import com.proofpoint.bootstrap.LifeCycleConfig;
import com.proofpoint.bootstrap.LifeCycleMethods;
import com.proofpoint.bootstrap.LifeCycleMethodsMap;
import com.proofpoint.bootstrap.StopTraffic;
import com.proofpoint.log.Logger;
import com.proofpoint.log.Logging;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

public final class LifeCycleManager {
    private final Logger log = Logger.get(this.getClass());
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private final ConcurrentLinkedQueue<Object> managedInstances = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Object> acceptRequestInstances = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Object> stopTrafficInstances = new ConcurrentLinkedQueue();
    private final LifeCycleMethodsMap methodsMap;
    private final LifeCycleConfig config;
    private final CountDownLatch stoppedLatch = new CountDownLatch(1);

    public LifeCycleManager(List<Object> managedInstances, @Nullable LifeCycleMethodsMap methodsMap, LifeCycleConfig config) throws Exception {
        this.methodsMap = methodsMap != null ? methodsMap : new LifeCycleMethodsMap();
        this.config = Objects.requireNonNull(config, "config is null");
        for (Object instance : managedInstances) {
            this.addInstance(instance);
        }
    }

    public int size() {
        return this.managedInstances.size() + this.acceptRequestInstances.size() + this.stopTrafficInstances.size();
    }

    public void start() throws Exception {
        LifeCycleMethods methods;
        if (!this.state.compareAndSet(State.LATENT, State.STARTING)) {
            throw new Exception("System already starting");
        }
        this.log.info("Life cycle starting...", new Object[0]);
        for (Object obj : this.acceptRequestInstances) {
            methods = this.methodsMap.get(obj.getClass());
            this.startInstance(obj, methods.methodsFor(AcceptRequests.class));
            if (methods.hasFor(PreDestroy.class)) continue;
            this.acceptRequestInstances.remove(obj);
        }
        for (Object obj : this.managedInstances) {
            methods = this.methodsMap.get(obj.getClass());
            if (methods.hasFor(PreDestroy.class)) continue;
            this.managedInstances.remove(obj);
        }
        Thread thread = new Thread(() -> {
            try {
                this.stop();
            }
            catch (Exception e) {
                this.log.error((Throwable)e, "Trying to shut down", new Object[0]);
            }
        });
        Runtime.getRuntime().addShutdownHook(thread);
        Logging.addShutdownLatchToWaitFor((CountDownLatch)this.stoppedLatch);
        this.state.set(State.STARTED);
        this.log.info("Life cycle startup complete. System ready.", new Object[0]);
    }

    public void stop() throws Exception {
        if (!this.state.compareAndSet(State.STARTED, State.STOPPING)) {
            return;
        }
        this.log.info("Life cycle stopping...", new Object[0]);
        this.stopList(this.stopTrafficInstances, StopTraffic.class);
        this.log.info("Life cycle unannounced...", new Object[0]);
        long stopTrafficDelay = this.config.getStopTrafficDelay().toMillis();
        if (stopTrafficDelay != 0L) {
            Thread.sleep(stopTrafficDelay);
        }
        this.stopList(this.acceptRequestInstances, PreDestroy.class);
        this.log.info("Life cycle stopped accepting new requests...", new Object[0]);
        this.stopList(this.managedInstances, PreDestroy.class);
        this.state.set(State.STOPPED);
        this.log.info("Life cycle stopped.", new Object[0]);
        this.stoppedLatch.countDown();
    }

    private void stopList(Queue<Object> instances, Class<? extends Annotation> annotation) {
        ArrayList reversedInstances = Lists.newArrayList(instances);
        Collections.reverse(reversedInstances);
        for (Object obj : reversedInstances) {
            this.log.debug("Stopping %s", new Object[]{obj.getClass().getName()});
            LifeCycleMethods methods = this.methodsMap.get(obj.getClass());
            for (Method preDestroy : methods.methodsFor(annotation)) {
                this.log.debug("\t%s()", new Object[]{preDestroy.getName()});
                try {
                    preDestroy.invoke(obj, new Object[0]);
                }
                catch (Exception e) {
                    this.log.error((Throwable)e, "Stopping %s.%s() failed:", new Object[]{obj.getClass().getName(), preDestroy.getName()});
                }
            }
        }
    }

    public void addInstance(Object instance) throws Exception {
        State currentState = this.state.get();
        if (currentState == State.STOPPING || currentState == State.STOPPED) {
            throw new IllegalStateException();
        }
        LifeCycleMethods methods = this.methodsMap.get(instance.getClass());
        this.startInstance(instance, methods.methodsFor(PostConstruct.class));
        if (methods.hasFor(AcceptRequests.class)) {
            this.acceptRequestInstances.add(instance);
        } else if (methods.hasFor(PreDestroy.class)) {
            this.managedInstances.add(instance);
        }
        if (methods.hasFor(StopTraffic.class)) {
            this.stopTrafficInstances.add(instance);
        }
    }

    private void startInstance(Object obj, Collection<Method> methods) throws IllegalAccessException, InvocationTargetException {
        this.log.debug("Starting %s", new Object[]{obj.getClass().getName()});
        for (Method method : methods) {
            this.log.debug("\t%s()", new Object[]{method.getName()});
            method.invoke(obj, new Object[0]);
        }
    }

    private static enum State {
        LATENT,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }
}

