/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.bootstrap;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.proofpoint.bootstrap.AcceptRequests;
import com.proofpoint.bootstrap.LifeCycleConfig;
import com.proofpoint.bootstrap.LifeCycleManager;
import com.proofpoint.bootstrap.LifeCycleMethods;
import com.proofpoint.bootstrap.LifeCycleMethodsMap;
import com.proofpoint.bootstrap.StopTraffic;
import com.proofpoint.configuration.ConfigBinder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

public class LifeCycleModule
implements Module {
    private final List<Object> injectedInstances = new ArrayList<Object>();
    private final LifeCycleMethodsMap lifeCycleMethodsMap = new LifeCycleMethodsMap();
    private final AtomicReference<LifeCycleManager> lifeCycleManager = new AtomicReference<Object>(null);

    public void configure(Binder binder) {
        binder.disableCircularProxies();
        ConfigBinder.bindConfig((Binder)binder).bind(LifeCycleConfig.class);
        binder.bindListener(Matchers.any(), new TypeListener(){

            public <T> void hear(TypeLiteral<T> type, TypeEncounter<T> encounter) {
                encounter.register(obj -> {
                    if (LifeCycleModule.this.isLifeCycleClass(obj.getClass())) {
                        LifeCycleManager lifeCycleManager = (LifeCycleManager)LifeCycleModule.this.lifeCycleManager.get();
                        if (lifeCycleManager != null) {
                            try {
                                lifeCycleManager.addInstance(obj);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        } else {
                            LifeCycleModule.this.injectedInstances.add(obj);
                        }
                    }
                });
            }
        });
    }

    @Provides
    @Singleton
    public LifeCycleManager getServerManager(LifeCycleConfig config) throws Exception {
        LifeCycleManager lifeCycleManager = new LifeCycleManager(this.injectedInstances, this.lifeCycleMethodsMap, config);
        this.lifeCycleManager.set(lifeCycleManager);
        return lifeCycleManager;
    }

    private boolean isLifeCycleClass(Class<?> clazz) {
        LifeCycleMethods methods = this.lifeCycleMethodsMap.get(clazz);
        return methods.hasFor(PostConstruct.class) || methods.hasFor(AcceptRequests.class) || methods.hasFor(PreDestroy.class) || methods.hasFor(StopTraffic.class);
    }
}

