/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.json;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import com.proofpoint.json.ObjectMapperProvider;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class JsonCodec<T> {
    private static final java.util.function.Supplier<ObjectMapper> OBJECT_MAPPER_SUPPLIER = () -> ((Supplier)Suppliers.memoize(() -> new ObjectMapperProvider().get().enable(SerializationFeature.INDENT_OUTPUT))).get();
    private final ObjectMapper mapper;
    private final Type type;
    private final JavaType javaType;

    public static <T> JsonCodec<T> jsonCodec(Class<T> type) {
        Objects.requireNonNull(type, "type is null");
        return new JsonCodec<T>(OBJECT_MAPPER_SUPPLIER.get(), type);
    }

    public static <T> JsonCodec<T> jsonCodec(TypeToken<T> type) {
        Objects.requireNonNull(type, "type is null");
        return new JsonCodec<T>(OBJECT_MAPPER_SUPPLIER.get(), type.getType());
    }

    public static <T> JsonCodec<List<T>> listJsonCodec(Class<T> type) {
        Objects.requireNonNull(type, "type is null");
        Type listType = new TypeToken<List<T>>(){}.where(new TypeParameter<T>(){}, type).getType();
        return new JsonCodec<List<T>>(OBJECT_MAPPER_SUPPLIER.get(), listType);
    }

    public static <T> JsonCodec<List<T>> listJsonCodec(JsonCodec<T> type) {
        Objects.requireNonNull(type, "type is null");
        Type listType = new TypeToken<List<T>>(){}.where(new TypeParameter<T>(){}, type.getTypeToken()).getType();
        return new JsonCodec<List<T>>(OBJECT_MAPPER_SUPPLIER.get(), listType);
    }

    public static <K, V> JsonCodec<Map<K, V>> mapJsonCodec(Class<K> keyType, Class<V> valueType) {
        Objects.requireNonNull(keyType, "keyType is null");
        Objects.requireNonNull(valueType, "valueType is null");
        Type mapType = new TypeToken<Map<K, V>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType).getType();
        return new JsonCodec<Map<K, V>>(OBJECT_MAPPER_SUPPLIER.get(), mapType);
    }

    public static <K, V> JsonCodec<Map<K, V>> mapJsonCodec(Class<K> keyType, JsonCodec<V> valueType) {
        Objects.requireNonNull(keyType, "keyType is null");
        Objects.requireNonNull(valueType, "valueType is null");
        Type mapType = new TypeToken<Map<K, V>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType.getTypeToken()).getType();
        return new JsonCodec<Map<K, V>>(OBJECT_MAPPER_SUPPLIER.get(), mapType);
    }

    JsonCodec(ObjectMapper mapper, Type type) {
        this.mapper = mapper;
        this.type = type;
        this.javaType = mapper.getTypeFactory().constructType(type);
    }

    public JsonCodec<T> withoutPretty() {
        return new JsonCodec<T>(this.mapper.copy().disable(SerializationFeature.INDENT_OUTPUT), this.type);
    }

    public Type getType() {
        return this.type;
    }

    public T fromJson(String json) throws IllegalArgumentException {
        try {
            return (T)this.mapper.readValue(json, this.javaType);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Invalid JSON string for %s", this.javaType), e);
        }
    }

    public String toJson(T instance) throws IllegalArgumentException {
        try {
            return this.mapper.writeValueAsString(instance);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("%s could not be converted to JSON", instance.getClass().getName()), e);
        }
    }

    /*
     * Exception decompiling
     */
    public Optional<String> toJsonWithLengthLimit(T instance, int lengthLimit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public T fromJson(byte[] json) throws IllegalArgumentException {
        try {
            return (T)this.mapper.readValue(json, this.javaType);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Invalid JSON bytes for %s", this.javaType), e);
        }
    }

    public byte[] toJsonBytes(T instance) throws IllegalArgumentException {
        try {
            return this.mapper.writeValueAsBytes(instance);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("%s could not be converted to JSON", instance.getClass().getName()), e);
        }
    }

    TypeToken<T> getTypeToken() {
        return TypeToken.of((Type)this.type);
    }
}

