/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.json.testing;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.proofpoint.json.JsonCodec;
import com.proofpoint.json.ObjectMapperProvider;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.testng.Assert;

public class JsonTester {
    private JsonTester() {
    }

    public static <T> void assertJsonEncode(T pojo, Object expected) {
        JsonTester.assertJsonEncode(pojo, expected, null);
    }

    public static <T> void assertJsonEncode(T pojo, Object expected, String message) {
        try {
            String json = new ObjectMapperProvider().get().enable(SerializationFeature.INDENT_OUTPUT).writeValueAsString(pojo);
            StringBuilder builder = new StringBuilder();
            if (message != null) {
                builder.append(message).append(' ');
            }
            builder.append("JSON encoding ").append(json);
            Assert.assertEquals((Object)new ObjectMapper().readValue(json, Object.class), (Object)expected, (String)builder.toString());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> T decodeJson(Class<T> tClass, Object value) {
        return JsonTester.decodeJson(JsonCodec.jsonCodec(tClass), value);
    }

    public static <T> T decodeJson(JsonCodec<T> codec, Object value) {
        String json;
        try {
            json = new ObjectMapperProvider().get().writeValueAsString(value);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return codec.fromJson(json);
    }
}

