/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.audit;

import com.proofpoint.configuration.Config;
import com.proofpoint.configuration.ConfigDescription;
import com.proofpoint.units.DataSize;

public class AuditConfiguration {
    private String logPath = null;
    private DataSize maxSegmentSize = new DataSize(100.0, DataSize.Unit.MEGABYTE);
    private int maxHistory = 30;
    private DataSize maxTotalSize = new DataSize(1.0, DataSize.Unit.GIGABYTE);

    public String getLogPath() {
        return this.logPath;
    }

    @Config(value="audit.log.path")
    public AuditConfiguration setLogPath(String logPath) {
        this.logPath = logPath;
        return this;
    }

    public DataSize getMaxSegmentSize() {
        return this.maxSegmentSize;
    }

    @Config(value="audit.log.max-size")
    @ConfigDescription(value="Maximum size of a single audit log file")
    public AuditConfiguration setMaxSegmentSize(DataSize maxSegmentSize) {
        this.maxSegmentSize = maxSegmentSize;
        return this;
    }

    public int getMaxHistory() {
        return this.maxHistory;
    }

    @Config(value="audit.log.max-history")
    public AuditConfiguration setMaxHistory(int maxHistory) {
        this.maxHistory = maxHistory;
        return this;
    }

    public DataSize getMaxTotalSize() {
        return this.maxTotalSize;
    }

    @Config(value="audit.log.max-total-size")
    @ConfigDescription(value="Maximum size of all archived log files")
    public AuditConfiguration setMaxTotalSize(DataSize maxTotalSize) {
        this.maxTotalSize = maxTotalSize;
        return this;
    }
}

