/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.audit;

import ch.qos.logback.core.Appender;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.auto.value.AutoValue;
import com.proofpoint.audit.AuditLogger;
import com.proofpoint.audit.AutoValue_FileAuditLogger_AuditWrapper;
import com.proofpoint.audit.DateTimeSupplier;
import com.proofpoint.tracetoken.TraceToken;
import com.proofpoint.tracetoken.TraceTokenManager;
import java.time.Instant;
import java.util.Objects;
import javax.annotation.Nullable;

final class FileAuditLogger<T>
implements AuditLogger<T> {
    private final String type;
    private final DateTimeSupplier dateTimeSupplier;
    private final Appender<AuditWrapper> fileAppender;

    FileAuditLogger(Class<T> recordClass, DateTimeSupplier dateTimeSupplier, Appender<AuditWrapper> fileAppender) {
        this.type = recordClass.getCanonicalName();
        this.dateTimeSupplier = Objects.requireNonNull(dateTimeSupplier, "dateTimeSupplier is null");
        this.fileAppender = Objects.requireNonNull(fileAppender, "fileAppender is null");
    }

    @Override
    public void audit(T record) {
        try {
            this.fileAppender.doAppend((Object)AuditWrapper.auditWrapper(this.dateTimeSupplier.get(), this.type, record));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @JsonPropertyOrder(value={"time", "type", "traceToken", "object"})
    @AutoValue
    static abstract class AuditWrapper {
        AuditWrapper() {
        }

        @JsonProperty
        public abstract Instant getTime();

        @JsonProperty
        public abstract String getType();

        @Nullable
        @JsonProperty
        public abstract TraceToken getTraceToken();

        @JsonUnwrapped
        public abstract Object getObject();

        public static AuditWrapper auditWrapper(Instant time, String type, Object object) {
            return new AutoValue_FileAuditLogger_AuditWrapper(time, type, TraceTokenManager.getCurrentTraceToken(), object);
        }
    }
}

