/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.audit;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.EncoderBase;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.proofpoint.audit.AuditConfiguration;
import com.proofpoint.audit.AuditLogger;
import com.proofpoint.audit.AuditLoggerFactory;
import com.proofpoint.audit.DateTimeSupplier;
import com.proofpoint.audit.FileAuditLogger;
import com.proofpoint.log.Logger;
import com.proofpoint.log.Logging;
import com.proofpoint.units.DataSize;
import java.util.Objects;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class FileAuditLoggerFactory
implements AuditLoggerFactory {
    private static final Logger log = Logger.get(FileAuditLoggerFactory.class);
    private final DateTimeSupplier dateTimeSupplier;
    private final Appender<FileAuditLogger.AuditWrapper> fileAppender;

    @Inject
    public FileAuditLoggerFactory(AuditConfiguration config, DateTimeSupplier dateTimeSupplier, ObjectMapper mapper) {
        this.dateTimeSupplier = Objects.requireNonNull(dateTimeSupplier, "dateTimeSupplier is null");
        String logPath = config.getLogPath();
        log.info("Audit logging to %s", new Object[]{logPath});
        this.fileAppender = Logging.createFileAppender((String)logPath, (int)config.getMaxHistory(), (DataSize)config.getMaxSegmentSize(), (DataSize)config.getMaxTotalSize(), (Encoder)new JsonEncoder(mapper), (Context)new ContextBase());
    }

    @Override
    public <T> AuditLogger<T> create(Class<T> recordClass) {
        return new FileAuditLogger<T>(recordClass, this.dateTimeSupplier, this.fileAppender);
    }

    @PreDestroy
    public void close() {
        try {
            this.fileAppender.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static final class JsonEncoder
    extends EncoderBase<FileAuditLogger.AuditWrapper> {
        private final ObjectMapper mapper;

        private JsonEncoder(ObjectMapper mapper) {
            this.mapper = Objects.requireNonNull(mapper, "mapper is null");
        }

        public byte[] headerBytes() {
            return null;
        }

        public byte[] encode(FileAuditLogger.AuditWrapper event) {
            try {
                byte[] jsonBytes = this.mapper.writeValueAsBytes((Object)event);
                byte[] line = new byte[jsonBytes.length + 1];
                System.arraycopy(jsonBytes, 0, line, 0, jsonBytes.length);
                line[jsonBytes.length] = 10;
                return line;
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException(String.format("%s could not be converted to json", event.getClass().getName()), e);
            }
        }

        public byte[] footerBytes() {
            return null;
        }
    }
}

