/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.audit.testing;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.auto.value.AutoValue;
import com.proofpoint.audit.AuditLogger;
import com.proofpoint.audit.testing.AutoValue_TestingAuditLogger_AuditWrapper;
import com.proofpoint.audit.testing.TestingAuditLog;
import com.proofpoint.tracetoken.TraceToken;
import com.proofpoint.tracetoken.TraceTokenManager;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

public class TestingAuditLogger<T>
implements AuditLogger<T> {
    private final String type;
    private final ObjectMapper objectMapper;
    private final TestingAuditLog auditLog;

    TestingAuditLogger(Class<T> recordClass, ObjectMapper objectMapper, TestingAuditLog auditLog) {
        this.type = recordClass.getCanonicalName();
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper is null");
        this.auditLog = Objects.requireNonNull(auditLog, "auditLog is null");
    }

    @Override
    public void audit(T record) {
        Object value;
        try {
            String json = this.objectMapper.writeValueAsString((Object)AuditWrapper.auditWrapper(this.type, record));
            value = this.objectMapper.readValue(json, Object.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.auditLog.add(value);
    }

    @AutoValue
    static abstract class AuditWrapper {
        AuditWrapper() {
        }

        @JsonProperty
        public abstract String getType();

        @Nullable
        @JsonProperty
        public abstract TraceToken getTraceToken();

        @JsonUnwrapped
        public abstract Object getObject();

        public static AuditWrapper auditWrapper(String type, Object object) {
            return new AutoValue_TestingAuditLogger_AuditWrapper(type, TraceTokenManager.getCurrentTraceToken(), object);
        }
    }
}

