/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.node;

import com.google.common.net.InetAddresses;
import com.proofpoint.configuration.Config;
import com.proofpoint.configuration.DefunctConfig;
import java.net.InetAddress;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

@DefunctConfig(value={"http-server.ip", "jetty.ip", "node.binary-spec", "node.config-spec"})
public class NodeConfig {
    public static final String ID_REGEXP = "[A-Za-z0-9][_A-Za-z0-9-]*";
    public static final String ENV_REGEXP = "[a-z0-9][_a-z0-9]*";
    public static final String HOSTNAME_REGEXP = "[a-z0-9][-_a-z0-9]*(?:\\.[a-z0-9][-_a-z0-9]*)+";
    public static final String POOL_REGEXP = "[a-zA-Z0-9][-_a-zA-Z0-9]*";
    private String environment;
    private String pool = "general";
    private String nodeId;
    private String location;
    private InetAddress nodeInternalIp;
    private String nodeInternalHostname;
    private String nodeExternalAddress;
    private InetAddress nodeBindIp;

    @NotNull
    @Pattern(regexp="[a-z0-9][_a-z0-9]*", message="is malformed")
    public @NotNull @Pattern(regexp="[a-z0-9][_a-z0-9]*", message="is malformed") String getEnvironment() {
        return this.environment;
    }

    @Config(value="node.environment")
    public NodeConfig setEnvironment(String environment) {
        this.environment = environment;
        return this;
    }

    @NotNull
    @Pattern(regexp="[a-zA-Z0-9][-_a-zA-Z0-9]*", message="is malformed")
    public @NotNull @Pattern(regexp="[a-zA-Z0-9][-_a-zA-Z0-9]*", message="is malformed") String getPool() {
        return this.pool;
    }

    @Config(value="node.pool")
    public NodeConfig setPool(String pool) {
        this.pool = pool;
        return this;
    }

    @Pattern(regexp="[A-Za-z0-9][_A-Za-z0-9-]*", message="is malformed")
    public @Pattern(regexp="[A-Za-z0-9][_A-Za-z0-9-]*", message="is malformed") String getNodeId() {
        return this.nodeId;
    }

    @Config(value="node.id")
    public NodeConfig setNodeId(String nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    @Config(value="node.location")
    public NodeConfig setLocation(String location) {
        this.location = location;
        return this;
    }

    public InetAddress getNodeInternalIp() {
        return this.nodeInternalIp;
    }

    public NodeConfig setNodeInternalIp(InetAddress nodeInternalIp) {
        this.nodeInternalIp = nodeInternalIp;
        return this;
    }

    @Config(value="node.ip")
    public NodeConfig setNodeInternalIp(String nodeInternalIp) {
        if (nodeInternalIp != null) {
            this.nodeInternalIp = InetAddresses.forString((String)nodeInternalIp);
        }
        return this;
    }

    @Pattern(regexp="[a-z0-9][-_a-z0-9]*(?:\\.[a-z0-9][-_a-z0-9]*)+", message="is malformed")
    public @Pattern(regexp="[a-z0-9][-_a-z0-9]*(?:\\.[a-z0-9][-_a-z0-9]*)+", message="is malformed") String getNodeInternalHostname() {
        return this.nodeInternalHostname;
    }

    @Config(value="node.hostname")
    public NodeConfig setNodeInternalHostname(String nodeInternalHostname) {
        this.nodeInternalHostname = nodeInternalHostname;
        return this;
    }

    public String getNodeExternalAddress() {
        return this.nodeExternalAddress;
    }

    @Config(value="node.external-address")
    public NodeConfig setNodeExternalAddress(String nodeExternalAddress) {
        this.nodeExternalAddress = nodeExternalAddress;
        return this;
    }

    public InetAddress getNodeBindIp() {
        return this.nodeBindIp;
    }

    public NodeConfig setNodeBindIp(InetAddress nodeBindIp) {
        this.nodeBindIp = nodeBindIp;
        return this;
    }

    @Config(value="node.bind-ip")
    public NodeConfig setNodeBindIp(String nodeBindIp) {
        if (nodeBindIp != null) {
            this.nodeBindIp = InetAddresses.forString((String)nodeBindIp);
        }
        return this;
    }
}

