/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.client;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CacheControl {
    private static final String SEPARATOR = ",";
    private static final String COMPLEX_HEADER_EXPRESSION = "(([\\w-]+=\"[^\"]*\")|([\\w-]+=[\\w]+)|([\\w-]+))";
    private static final Pattern COMPLEX_HEADER_PATTERN = Pattern.compile("(([\\w-]+=\"[^\"]*\")|([\\w-]+=[\\w]+)|([\\w-]+))");
    private static final String PUBLIC = "public";
    private static final String PRIVATE = "private";
    private static final String NO_CACHE = "no-cache";
    private static final String NO_STORE = "no-store";
    private static final String NO_TRANSFORM = "no-transform";
    private static final String MUST_REVALIDATE = "must-revalidate";
    private static final String PROXY_REVALIDATE = "proxy-revalidate";
    private static final String MAX_AGE = "max-age";
    private static final String SMAX_AGE = "s-maxage";
    private int maxAge = -1;
    private int sMaxAge = -1;
    private boolean isPrivate = false;
    private boolean noCache = false;
    private boolean noStore = false;
    private boolean noTransform = true;
    private boolean mustRevalidate = false;
    private boolean proxyRevalidate = false;
    private Map<String, String> cacheExtensions = null;
    private List<String> noCacheFields = null;
    private List<String> privateFields = null;

    public Map<String, String> getCacheExtension() {
        if (this.cacheExtensions == null) {
            this.cacheExtensions = new HashMap<String, String>();
        }
        return this.cacheExtensions;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public List<String> getNoCacheFields() {
        if (this.noCacheFields == null) {
            this.noCacheFields = new ArrayList<String>();
        }
        return this.noCacheFields;
    }

    public List<String> getPrivateFields() {
        if (this.privateFields == null) {
            this.privateFields = new ArrayList<String>();
        }
        return this.privateFields;
    }

    public int getSMaxAge() {
        return this.sMaxAge;
    }

    public boolean isMustRevalidate() {
        return this.mustRevalidate;
    }

    public boolean isNoCache() {
        return this.noCache;
    }

    public boolean isNoStore() {
        return this.noStore;
    }

    public boolean isNoTransform() {
        return this.noTransform;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean isProxyRevalidate() {
        return this.proxyRevalidate;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public void setMustRevalidate(boolean mustRevalidate) {
        this.mustRevalidate = mustRevalidate;
    }

    public void setNoCache(boolean noCache) {
        this.noCache = noCache;
    }

    public void setNoStore(boolean noStore) {
        this.noStore = noStore;
    }

    public void setNoTransform(boolean noTransform) {
        this.noTransform = noTransform;
    }

    public void setPrivate(boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    public void setProxyRevalidate(boolean proxyRevalidate) {
        this.proxyRevalidate = proxyRevalidate;
    }

    public void setSMaxAge(int sMaxAge) {
        this.sMaxAge = sMaxAge;
    }

    public static CacheControl valueOf(String string) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoTransform(false);
        List<String> tokens = CacheControl.getTokens(string);
        for (String rawToken : tokens) {
            String token = rawToken.trim();
            if (token.startsWith(MAX_AGE)) {
                cacheControl.setMaxAge(Integer.parseInt(token.substring(MAX_AGE.length() + 1)));
                continue;
            }
            if (token.startsWith(SMAX_AGE)) {
                cacheControl.setSMaxAge(Integer.parseInt(token.substring(SMAX_AGE.length() + 1)));
                continue;
            }
            if (token.startsWith(PUBLIC)) continue;
            if (token.startsWith(NO_STORE)) {
                cacheControl.setNoStore(true);
                continue;
            }
            if (token.startsWith(NO_TRANSFORM)) {
                cacheControl.setNoTransform(true);
                continue;
            }
            if (token.startsWith(MUST_REVALIDATE)) {
                cacheControl.setMustRevalidate(true);
                continue;
            }
            if (token.startsWith(PROXY_REVALIDATE)) {
                cacheControl.setProxyRevalidate(true);
                continue;
            }
            if (token.startsWith(PRIVATE)) {
                cacheControl.setPrivate(true);
                CacheControl.addFields(cacheControl.getPrivateFields(), token);
                continue;
            }
            if (token.startsWith(NO_CACHE)) {
                cacheControl.setNoCache(true);
                CacheControl.addFields(cacheControl.getNoCacheFields(), token);
                continue;
            }
            ImmutableList pair = ImmutableList.copyOf((Iterable)Splitter.on((String)"=").limit(2).split((CharSequence)token));
            if (pair.size() == 2) {
                cacheControl.getCacheExtension().put((String)pair.get(0), (String)pair.get(1));
                continue;
            }
            cacheControl.getCacheExtension().put((String)pair.get(0), "");
        }
        return cacheControl;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.isPrivate()) {
            buffer.append(PRIVATE);
            CacheControl.handleFields(this.getPrivateFields(), buffer);
            buffer.append(SEPARATOR);
        }
        if (this.isNoCache()) {
            buffer.append(NO_CACHE);
            CacheControl.handleFields(this.getNoCacheFields(), buffer);
            buffer.append(SEPARATOR);
        }
        if (this.isNoStore()) {
            buffer.append(NO_STORE).append(SEPARATOR);
        }
        if (this.isNoTransform()) {
            buffer.append(NO_TRANSFORM).append(SEPARATOR);
        }
        if (this.isMustRevalidate()) {
            buffer.append(MUST_REVALIDATE).append(SEPARATOR);
        }
        if (this.isProxyRevalidate()) {
            buffer.append(PROXY_REVALIDATE).append(SEPARATOR);
        }
        if (this.getMaxAge() != -1) {
            buffer.append(MAX_AGE).append('=').append(this.getMaxAge()).append(SEPARATOR);
        }
        if (this.getSMaxAge() != -1) {
            buffer.append(SMAX_AGE).append('=').append(this.getSMaxAge()).append(SEPARATOR);
        }
        Map<String, String> extension = this.getCacheExtension();
        for (Map.Entry<String, String> entry : extension.entrySet()) {
            buffer.append(entry.getKey());
            String value = entry.getValue();
            if (value != null) {
                buffer.append("=");
                if (value.indexOf(32) != -1) {
                    buffer.append('\"').append(value).append('\"');
                } else {
                    buffer.append(value);
                }
            }
            buffer.append(SEPARATOR);
        }
        String string = buffer.toString();
        if (string.endsWith(SEPARATOR)) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private static void handleFields(List<String> fields, StringBuilder buffer) {
        if (fields.isEmpty()) {
            return;
        }
        buffer.append('=');
        buffer.append('\"');
        Iterator<String> it = fields.iterator();
        while (it.hasNext()) {
            buffer.append(it.next());
            if (!it.hasNext()) continue;
            buffer.append(',');
        }
        buffer.append('\"');
    }

    private static List<String> getTokens(String string) {
        if (string.contains("\"")) {
            ArrayList<String> values = new ArrayList<String>(4);
            Matcher m = COMPLEX_HEADER_PATTERN.matcher(string);
            while (m.find()) {
                String val = m.group().trim();
                if (val.length() <= 0) continue;
                values.add(val);
            }
            return ImmutableList.copyOf(values);
        }
        return ImmutableList.copyOf((Iterable)Splitter.on((String)SEPARATOR).split((CharSequence)string));
    }

    private static void addFields(List<String> fields, String token) {
        int i = token.indexOf(61);
        if (i != -1) {
            String f;
            String string = f = i == token.length() + 1 ? "" : token.substring(i + 1);
            if (f.length() >= 2 && f.startsWith("\"") && f.endsWith("\"")) {
                String string2 = f = f.length() == 2 ? "" : f.substring(1, f.length() - 1);
                if (f.length() > 0) {
                    ImmutableList values = ImmutableList.copyOf((Iterable)Splitter.on((String)SEPARATOR).split((CharSequence)f));
                    for (String v : values) {
                        fields.add(v.trim());
                    }
                }
            }
        }
    }

    public int hashCode() {
        return Objects.hash(this.maxAge, this.sMaxAge, this.isPrivate, this.noCache, this.noStore, this.noTransform, this.mustRevalidate, this.proxyRevalidate, this.cacheExtensions, this.noCacheFields, this.privateFields);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CacheControl other = (CacheControl)obj;
        return Objects.equals(this.maxAge, other.maxAge) && Objects.equals(this.sMaxAge, other.sMaxAge) && Objects.equals(this.isPrivate, other.isPrivate) && Objects.equals(this.noCache, other.noCache) && Objects.equals(this.noStore, other.noStore) && Objects.equals(this.noTransform, other.noTransform) && Objects.equals(this.mustRevalidate, other.mustRevalidate) && Objects.equals(this.proxyRevalidate, other.proxyRevalidate) && Objects.equals(this.cacheExtensions, other.cacheExtensions) && Objects.equals(this.noCacheFields, other.noCacheFields) && Objects.equals(this.privateFields, other.privateFields);
    }
}

