/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.client;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.dataformat.smile.SmileParser;
import com.google.common.base.MoreObjects;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.net.MediaType;
import com.proofpoint.http.client.HeaderName;
import com.proofpoint.http.client.Request;
import com.proofpoint.http.client.Response;
import com.proofpoint.http.client.ResponseHandler;
import com.proofpoint.http.client.ResponseHandlerUtils;
import com.proofpoint.json.JsonCodec;
import com.proofpoint.json.ObjectMapperProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class FullSmileResponseHandler<T>
implements ResponseHandler<SmileResponse<T>, RuntimeException> {
    private static final MediaType MEDIA_TYPE_SMILE = MediaType.create((String)"application", (String)"x-jackson-smile");
    private final JsonCodec<T> jsonCodec;

    public static <T> FullSmileResponseHandler<T> createFullSmileResponseHandler(JsonCodec<T> jsonCodec) {
        return new FullSmileResponseHandler<T>(jsonCodec);
    }

    private FullSmileResponseHandler(JsonCodec<T> jsonCodec) {
        this.jsonCodec = jsonCodec;
    }

    @Override
    public SmileResponse<T> handleException(Request request, Exception exception) {
        throw ResponseHandlerUtils.propagate(request, exception);
    }

    @Override
    public SmileResponse<T> handle(Request request, Response response) {
        String contentType = response.getHeader("Content-Type");
        if (contentType == null || !MediaType.parse((String)contentType).is(MEDIA_TYPE_SMILE)) {
            return new SmileResponse(response.getStatusCode(), response.getStatusMessage(), response.getHeaders());
        }
        try {
            return new SmileResponse<T>(response.getStatusCode(), response.getStatusMessage(), response.getHeaders(), this.jsonCodec, response.getInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading SMILE response from server", e);
        }
    }

    public static class SmileResponse<T> {
        private static final Supplier<ObjectMapper> OBJECT_MAPPER_SUPPLIER = Suppliers.memoize(() -> new ObjectMapperProvider().get());
        private final int statusCode;
        private final String statusMessage;
        private final ListMultimap<HeaderName, String> headers;
        private final boolean hasValue;
        private final T value;
        private final IllegalArgumentException exception;

        public SmileResponse(int statusCode, String statusMessage, ListMultimap<HeaderName, String> headers) {
            this.statusCode = statusCode;
            this.statusMessage = statusMessage;
            this.headers = ImmutableListMultimap.copyOf(headers);
            this.hasValue = false;
            this.value = null;
            this.exception = null;
        }

        public SmileResponse(int statusCode, String statusMessage, ListMultimap<HeaderName, String> headers, JsonCodec<T> jsonCodec, InputStream inputStream) throws IOException {
            this.statusCode = statusCode;
            this.statusMessage = statusMessage;
            this.headers = ImmutableListMultimap.copyOf(headers);
            Object value = null;
            IllegalArgumentException exception = null;
            try {
                SmileParser jsonParser = new SmileFactory().createParser(inputStream);
                ObjectMapper objectMapper = (ObjectMapper)OBJECT_MAPPER_SUPPLIER.get();
                jsonParser.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
                value = objectMapper.readValue((JsonParser)jsonParser, objectMapper.getTypeFactory().constructType(jsonCodec.getType()));
            }
            catch (InvalidFormatException e) {
                exception = new IllegalArgumentException("Unable to create " + jsonCodec.getType() + " from SMILE response", e);
            }
            this.hasValue = exception == null;
            this.value = value;
            this.exception = exception;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getStatusMessage() {
            return this.statusMessage;
        }

        public String getHeader(String name) {
            List values = this.getHeaders().get((Object)HeaderName.of(name));
            if (values.isEmpty()) {
                return null;
            }
            return (String)values.get(0);
        }

        public List<String> getHeaders(String name) {
            return this.headers.get((Object)HeaderName.of(name));
        }

        public ListMultimap<HeaderName, String> getHeaders() {
            return this.headers;
        }

        public boolean hasValue() {
            return this.hasValue;
        }

        public T getValue() {
            if (!this.hasValue) {
                throw new IllegalStateException("Response does not contain a SMILE value", this.exception);
            }
            return this.value;
        }

        public IllegalArgumentException getException() {
            return this.exception;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("statusCode", this.statusCode).add("statusMessage", (Object)this.statusMessage).add("headers", this.headers).add("hasValue", this.hasValue).add("value", this.value).toString();
        }
    }
}

