/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.client;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class GatheringByteArrayInputStream
extends InputStream {
    @GuardedBy(value="this")
    private final Iterator<byte[]> buffers;
    @GuardedBy(value="this")
    private final byte[] singleByte = new byte[1];
    @GuardedBy(value="this")
    private byte[] currentBuffer = new byte[0];
    @GuardedBy(value="this")
    private int currentBufferPosition;
    @GuardedBy(value="this")
    private long remainingBytes;

    public GatheringByteArrayInputStream(List<byte[]> buffers, long totalBytes) {
        Preconditions.checkArgument((totalBytes >= 0L ? 1 : 0) != 0, (Object)"totalBytes should equal to or greater than 0");
        this.buffers = Objects.requireNonNull(buffers, "buffers is null").iterator();
        this.remainingBytes = totalBytes;
    }

    @Override
    public synchronized int read(byte[] buffer) {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public synchronized int read() {
        int bytes = this.read(this.singleByte);
        if (bytes == -1) {
            return -1;
        }
        return this.singleByte[0] & 0xFF;
    }

    @Override
    public synchronized long skip(long n) {
        long totalSkippedBytes;
        if (n < 0L) {
            return 0L;
        }
        n = totalSkippedBytes = Math.min(n, this.remainingBytes);
        while (n > 0L) {
            if (this.currentBufferPosition >= this.currentBuffer.length) {
                this.advanceCurrentBuffer();
            }
            int skippedBytes = (int)Math.min(n, (long)(this.currentBuffer.length - this.currentBufferPosition));
            n -= (long)skippedBytes;
            this.currentBufferPosition += skippedBytes;
        }
        this.remainingBytes -= totalSkippedBytes;
        return totalSkippedBytes;
    }

    @Override
    public synchronized int read(byte[] buffer, int offset, int length) {
        int totalReadBytes;
        Objects.requireNonNull(buffer, "buffer is null");
        Preconditions.checkPositionIndexes((int)offset, (int)(offset + length), (int)buffer.length);
        if (this.remainingBytes == 0L) {
            return -1;
        }
        length = totalReadBytes = (int)Math.min((long)length, this.remainingBytes);
        while (length > 0) {
            if (this.currentBufferPosition >= this.currentBuffer.length) {
                this.advanceCurrentBuffer();
            }
            int readBytes = Math.min(length, this.currentBuffer.length - this.currentBufferPosition);
            System.arraycopy(this.currentBuffer, this.currentBufferPosition, buffer, offset, readBytes);
            offset += readBytes;
            length -= readBytes;
            this.currentBufferPosition += readBytes;
        }
        this.remainingBytes -= (long)totalReadBytes;
        return totalReadBytes;
    }

    @Override
    public void close() {
    }

    private synchronized void advanceCurrentBuffer() {
        Preconditions.checkState((this.currentBufferPosition >= this.currentBuffer.length ? 1 : 0) != 0, (Object)"there is still un-read space in currentBuffer");
        Preconditions.checkState((boolean)this.buffers.hasNext(), (Object)"buffers should have more data when remainingBytes is greater than 0");
        this.currentBuffer = this.buffers.next();
        this.currentBufferPosition = 0;
    }
}

