/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.client;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.PrivateBinder;
import com.google.inject.Scopes;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.multibindings.Multibinder;
import com.proofpoint.configuration.ConfigBinder;
import com.proofpoint.http.client.HttpClient;
import com.proofpoint.http.client.HttpClientBindOptions;
import com.proofpoint.http.client.HttpClientModule;
import com.proofpoint.http.client.HttpRequestFilter;
import com.proofpoint.http.client.RetryExecutorProvider;
import com.proofpoint.http.client.StaticHttpServiceBalancerProvider;
import com.proofpoint.http.client.balancing.BalancingHttpClient;
import com.proofpoint.http.client.balancing.BalancingHttpClientBindingBuilder;
import com.proofpoint.http.client.balancing.BalancingHttpClientConfig;
import com.proofpoint.http.client.balancing.ForBalancingHttpClient;
import com.proofpoint.http.client.balancing.HttpServiceBalancer;
import com.proofpoint.http.client.balancing.HttpServiceBalancerConfig;
import com.proofpoint.reporting.ReportBinder;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Provider;
import org.weakref.jmx.ObjectNameBuilder;
import org.weakref.jmx.guice.ExportBinder;

public class HttpClientBinder {
    private final Binder binder;
    private final Binder rootBinder;
    private final boolean isPrivate;

    private HttpClientBinder(Binder binder, Binder rootBinder, boolean isPrivate) {
        this.binder = Objects.requireNonNull(binder, "binder is null").skipSources(new Class[]{this.getClass()});
        this.rootBinder = Objects.requireNonNull(rootBinder, "rootBinder is null");
        this.isPrivate = isPrivate;
    }

    public static HttpClientBinder httpClientBinder(Binder binder) {
        return new HttpClientBinder(binder, binder, false);
    }

    public static HttpClientBinder httpClientPrivateBinder(Binder privateBinder, Binder rootBinder) {
        return new HttpClientBinder(privateBinder, rootBinder, true);
    }

    public HttpClientBindingBuilder bindHttpClient(String name, Class<? extends Annotation> annotation) {
        HttpClientModule module = new HttpClientModule(name, annotation, this.rootBinder, this.isPrivate);
        this.binder.install((Module)module);
        HttpClientBindOptions options = new HttpClientBindOptions();
        this.binder.bind(HttpClientBindOptions.class).annotatedWith(annotation).toInstance((Object)options);
        return new HttpClientBindingBuilder(module, Multibinder.newSetBinder((Binder)this.binder, HttpRequestFilter.class, annotation), options);
    }

    public BalancingHttpClientBindingBuilder bindBalancingHttpClient(String name, Class<? extends Annotation> annotation, Collection<URI> baseUris) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(annotation, "annotation is null");
        Objects.requireNonNull(baseUris, "baseUris is null");
        Preconditions.checkArgument((!baseUris.isEmpty() ? 1 : 0) != 0, (Object)"baseUris is empty");
        ConfigBinder.bindConfig((Binder)this.binder).bind(HttpServiceBalancerConfig.class).annotatedWith(annotation).prefixedWith("service-client." + annotation.getSimpleName());
        PrivateBinder privateBinder = this.binder.newPrivateBinder();
        privateBinder.bind(HttpServiceBalancer.class).annotatedWith(ForBalancingHttpClient.class).toProvider((Provider)new StaticHttpServiceBalancerProvider(annotation.getSimpleName(), baseUris, (Key<HttpServiceBalancerConfig>)Key.get(HttpServiceBalancerConfig.class, annotation)));
        return this.createBalancingHttpClientBindingBuilder(privateBinder, name, annotation);
    }

    public BalancingHttpClientBindingBuilder bindBalancingHttpClient(String name, Class<? extends Annotation> annotation, Key<? extends HttpServiceBalancer> balancerKey) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(annotation, "annotation is null");
        Objects.requireNonNull(balancerKey, "balancerKey is null");
        PrivateBinder privateBinder = this.binder.newPrivateBinder();
        privateBinder.bind(HttpServiceBalancer.class).annotatedWith(ForBalancingHttpClient.class).to(balancerKey);
        return this.createBalancingHttpClientBindingBuilder(privateBinder, name, annotation);
    }

    private BalancingHttpClientBindingBuilder createBalancingHttpClientBindingBuilder(PrivateBinder privateBinder, String name, Class<? extends Annotation> annotation) {
        HttpClientBindingBuilder delegateBindingBuilder = HttpClientBinder.httpClientPrivateBinder((Binder)privateBinder, this.binder).bindHttpClient(name, ForBalancingHttpClient.class);
        ConfigBinder.bindConfig((Binder)privateBinder).bind(BalancingHttpClientConfig.class).prefixedWith(name);
        privateBinder.bind(HttpClient.class).annotatedWith(annotation).to(BalancingHttpClient.class).in(Scopes.SINGLETON);
        privateBinder.expose(HttpClient.class).annotatedWith(annotation);
        ReportBinder.reportBinder((Binder)this.binder).export(HttpClient.class).annotatedWith(annotation);
        ExportBinder.newExporter((Binder)this.binder).export(HttpClient.class).annotatedWith(annotation).withGeneratedName();
        this.binder.bind(ScheduledExecutorService.class).annotatedWith(ForBalancingHttpClient.class).toProvider(RetryExecutorProvider.class);
        return new BalancingHttpClientBindingBuilder(this.binder, annotation, delegateBindingBuilder);
    }

    public BalancingHttpClientBindingBuilder bindBalancingHttpClient(String name, Annotation annotation, String serviceName, Collection<URI> baseUris) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(annotation, "annotation is null");
        Objects.requireNonNull(baseUris, "baseUris is null");
        Preconditions.checkArgument((!baseUris.isEmpty() ? 1 : 0) != 0, (Object)"baseUris is empty");
        ConfigBinder.bindConfig((Binder)this.binder).bind(HttpServiceBalancerConfig.class).annotatedWith(annotation).prefixedWith("service-client." + serviceName);
        PrivateBinder privateBinder = this.binder.newPrivateBinder();
        privateBinder.bind(HttpServiceBalancer.class).annotatedWith(ForBalancingHttpClient.class).toProvider((Provider)new StaticHttpServiceBalancerProvider(serviceName, baseUris, (Key<HttpServiceBalancerConfig>)Key.get(HttpServiceBalancerConfig.class, (Annotation)annotation)));
        return this.createBalancingHttpClientBindingBuilder(privateBinder, name, annotation, serviceName);
    }

    public BalancingHttpClientBindingBuilder bindBalancingHttpClient(String name, Annotation annotation, String serviceName, Key<? extends HttpServiceBalancer> balancerKey) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(annotation, "annotation is null");
        Objects.requireNonNull(balancerKey, "balancerKey is null");
        PrivateBinder privateBinder = this.binder.newPrivateBinder();
        privateBinder.bind(HttpServiceBalancer.class).annotatedWith(ForBalancingHttpClient.class).to(balancerKey);
        return this.createBalancingHttpClientBindingBuilder(privateBinder, name, annotation, serviceName);
    }

    private BalancingHttpClientBindingBuilder createBalancingHttpClientBindingBuilder(PrivateBinder privateBinder, String name, Annotation annotation, String serviceName) {
        HttpClientBindingBuilder delegateBindingBuilder = HttpClientBinder.httpClientPrivateBinder((Binder)privateBinder, this.binder).bindHttpClient(name, ForBalancingHttpClient.class);
        ConfigBinder.bindConfig((Binder)privateBinder).bind(BalancingHttpClientConfig.class).prefixedWith(name);
        privateBinder.bind(HttpClient.class).annotatedWith(annotation).to(BalancingHttpClient.class).in(Scopes.SINGLETON);
        privateBinder.expose(HttpClient.class).annotatedWith(annotation);
        ReportBinder.reportBinder((Binder)this.binder).export(HttpClient.class).annotatedWith(annotation).withNamePrefix("HttpClient." + serviceName);
        ExportBinder.newExporter((Binder)this.binder).export(HttpClient.class).annotatedWith(annotation).as(new ObjectNameBuilder(HttpClient.class.getPackage().getName()).withProperty("type", "HttpClient").withProperty("name", serviceName).build());
        this.binder.bind(ScheduledExecutorService.class).annotatedWith(ForBalancingHttpClient.class).toProvider(RetryExecutorProvider.class);
        return new BalancingHttpClientBindingBuilder(this.binder, annotation, delegateBindingBuilder);
    }

    public static class HttpClientBindingBuilder {
        private final HttpClientModule module;
        private final Multibinder<HttpRequestFilter> multibinder;
        private final HttpClientBindOptions options;

        private HttpClientBindingBuilder(HttpClientModule module, Multibinder<HttpRequestFilter> multibinder, HttpClientBindOptions options) {
            this.module = module;
            this.multibinder = multibinder;
            this.options = options;
        }

        public HttpClientBindingBuilder withAlias(Class<? extends Annotation> alias) {
            this.module.addAlias(alias);
            return this;
        }

        public HttpClientBindingBuilder withAliases(Collection<Class<? extends Annotation>> aliases) {
            aliases.forEach(this.module::addAlias);
            return this;
        }

        public LinkedBindingBuilder<HttpRequestFilter> addFilterBinding() {
            return this.multibinder.addBinding();
        }

        public HttpClientBindingBuilder withFilter(Class<? extends HttpRequestFilter> filterClass) {
            this.multibinder.addBinding().to(filterClass);
            return this;
        }

        @Deprecated
        public HttpClientBindingBuilder withTracing() {
            return this;
        }

        public HttpClientBindingBuilder withoutTracing() {
            this.options.setWithTracing(false);
            return this;
        }

        @Deprecated
        public HttpClientBindingBuilder withPrivateIoThreadPool() {
            return this;
        }
    }
}

