/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.client;

import com.google.common.net.HostAndPort;
import com.proofpoint.configuration.Config;
import com.proofpoint.configuration.ConfigDescription;
import com.proofpoint.configuration.DefunctConfig;
import com.proofpoint.configuration.LegacyConfig;
import com.proofpoint.units.DataSize;
import com.proofpoint.units.Duration;
import com.proofpoint.units.MaxDataSize;
import com.proofpoint.units.MinDataSize;
import com.proofpoint.units.MinDuration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"http-client.max-connections", "http-client.keep-alive-interval"})
public class HttpClientConfig {
    public static final String JAVAX_NET_SSL_KEY_STORE = "javax.net.ssl.keyStore";
    public static final String JAVAX_NET_SSL_KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    public static final String JAVAX_NET_SSL_TRUST_STORE = "javax.net.ssl.trustStore";
    public static final String JAVAX_NET_SSL_TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    private Duration connectTimeout = new Duration(2.0, TimeUnit.SECONDS);
    private Duration requestTimeout = null;
    private Duration idleTimeout = new Duration(1.0, TimeUnit.MINUTES);
    private int maxConnectionsPerServer = 100;
    private int maxRequestsQueuedPerDestination = 100;
    private DataSize maxContentLength = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private DataSize requestBufferSize = new DataSize(4.0, DataSize.Unit.KILOBYTE);
    private DataSize responseBufferSize = new DataSize(16.0, DataSize.Unit.KILOBYTE);
    private HostAndPort socksProxy;
    private String keyStorePath = System.getProperty("javax.net.ssl.keyStore");
    private String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
    private String trustStorePath;
    private String trustStorePassword;
    private int maxThreads = 200;
    private int minThreads = 8;
    private int timeoutThreads = 1;
    private int timeoutConcurrency = 1;
    private boolean http2Enabled;
    private DataSize http2InitialSessionReceiveWindowSize = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private DataSize http2InitialStreamReceiveWindowSize = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private DataSize http2InputBufferSize = new DataSize(8.0, DataSize.Unit.KILOBYTE);
    private int selectorCount = 2;

    public boolean isHttp2Enabled() {
        return this.http2Enabled;
    }

    @Config(value="http-client.http2.enabled")
    @ConfigDescription(value="Enable the HTTP/2 transport")
    public HttpClientConfig setHttp2Enabled(boolean http2Enabled) {
        this.http2Enabled = http2Enabled;
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    @Config(value="http-client.connect-timeout")
    public HttpClientConfig setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    @MinDuration(value="0ms")
    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    @Config(value="http-client.request-timeout")
    public HttpClientConfig setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    @Config(value="http-client.idle-timeout")
    @LegacyConfig(value={"http-client.read-timeout"})
    public HttpClientConfig setIdleTimeout(Duration idleTimeout) {
        this.idleTimeout = idleTimeout;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxConnectionsPerServer() {
        return this.maxConnectionsPerServer;
    }

    @Config(value="http-client.max-connections-per-server")
    public HttpClientConfig setMaxConnectionsPerServer(int maxConnectionsPerServer) {
        this.maxConnectionsPerServer = maxConnectionsPerServer;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxRequestsQueuedPerDestination() {
        return this.maxRequestsQueuedPerDestination;
    }

    @Config(value="http-client.max-requests-queued-per-destination")
    public HttpClientConfig setMaxRequestsQueuedPerDestination(int maxRequestsQueuedPerDestination) {
        this.maxRequestsQueuedPerDestination = maxRequestsQueuedPerDestination;
        return this;
    }

    @NotNull
    public DataSize getMaxContentLength() {
        return this.maxContentLength;
    }

    @Config(value="http-client.max-content-length")
    public HttpClientConfig setMaxContentLength(DataSize maxContentLength) {
        this.maxContentLength = maxContentLength;
        return this;
    }

    @NotNull
    @MaxDataSize(value="32MB")
    public DataSize getRequestBufferSize() {
        return this.requestBufferSize;
    }

    @Config(value="http-client.request-buffer-size")
    public HttpClientConfig setRequestBufferSize(DataSize requestBufferSize) {
        this.requestBufferSize = requestBufferSize;
        return this;
    }

    @NotNull
    @MaxDataSize(value="32MB")
    public DataSize getResponseBufferSize() {
        return this.responseBufferSize;
    }

    @Config(value="http-client.response-buffer-size")
    public HttpClientConfig setResponseBufferSize(DataSize responseBufferSize) {
        this.responseBufferSize = responseBufferSize;
        return this;
    }

    public HostAndPort getSocksProxy() {
        return this.socksProxy;
    }

    @Config(value="http-client.socks-proxy")
    public HttpClientConfig setSocksProxy(HostAndPort socksProxy) {
        this.socksProxy = socksProxy;
        return this;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    @Config(value="http-client.key-store-path")
    public HttpClientConfig setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
        return this;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @Config(value="http-client.key-store-password")
    public HttpClientConfig setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    @Config(value="http-client.trust-store-path")
    public HttpClientConfig setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
        return this;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    @Config(value="http-client.trust-store-password")
    public HttpClientConfig setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    @NotNull
    @MinDataSize(value="1kB")
    @MaxDataSize(value="1GB")
    public DataSize getHttp2InitialSessionReceiveWindowSize() {
        return this.http2InitialSessionReceiveWindowSize;
    }

    @Config(value="http-client.http2.session-receive-window-size")
    @ConfigDescription(value="Initial size of session's flow control receive window for HTTP/2")
    public HttpClientConfig setHttp2InitialSessionReceiveWindowSize(DataSize http2InitialSessionReceiveWindowSize) {
        this.http2InitialSessionReceiveWindowSize = http2InitialSessionReceiveWindowSize;
        return this;
    }

    @NotNull
    @MinDataSize(value="1kB")
    @MaxDataSize(value="1GB")
    public DataSize getHttp2InitialStreamReceiveWindowSize() {
        return this.http2InitialStreamReceiveWindowSize;
    }

    @Config(value="http-client.http2.stream-receive-window-size")
    @ConfigDescription(value="Initial size of stream's flow control receive window for HTTP/2")
    public HttpClientConfig setHttp2InitialStreamReceiveWindowSize(DataSize http2InitialStreamReceiveWindowSize) {
        this.http2InitialStreamReceiveWindowSize = http2InitialStreamReceiveWindowSize;
        return this;
    }

    @NotNull
    @MinDataSize(value="1kB")
    @MaxDataSize(value="32MB")
    public DataSize getHttp2InputBufferSize() {
        return this.http2InputBufferSize;
    }

    @Config(value="http-client.http2.input-buffer-size")
    @ConfigDescription(value="Size of the buffer used to read from the network for HTTP/2")
    public HttpClientConfig setHttp2InputBufferSize(DataSize http2InputBufferSize) {
        this.http2InputBufferSize = http2InputBufferSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getSelectorCount() {
        return this.selectorCount;
    }

    @Config(value="http-client.selector-count")
    public HttpClientConfig setSelectorCount(int selectorCount) {
        this.selectorCount = selectorCount;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxThreads() {
        return this.maxThreads;
    }

    @Config(value="http-client.max-threads")
    @LegacyConfig(value={"http-client.threads"})
    public HttpClientConfig setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMinThreads() {
        return this.minThreads;
    }

    @Config(value="http-client.min-threads")
    public HttpClientConfig setMinThreads(int minThreads) {
        this.minThreads = minThreads;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getTimeoutThreads() {
        return this.timeoutThreads;
    }

    @Config(value="http-client.timeout-threads")
    @ConfigDescription(value="Total number of timeout threads")
    public HttpClientConfig setTimeoutThreads(int timeoutThreads) {
        this.timeoutThreads = timeoutThreads;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getTimeoutConcurrency() {
        return this.timeoutConcurrency;
    }

    @Config(value="http-client.timeout-concurrency")
    @ConfigDescription(value="Number of concurrent locks for timeout")
    public HttpClientConfig setTimeoutConcurrency(int timeoutConcurrency) {
        this.timeoutConcurrency = timeoutConcurrency;
        return this;
    }
}

