/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.client;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.proofpoint.configuration.ConfigBinder;
import com.proofpoint.http.client.HttpClient;
import com.proofpoint.http.client.HttpClientBindOptions;
import com.proofpoint.http.client.HttpClientConfig;
import com.proofpoint.http.client.HttpRequestFilter;
import com.proofpoint.http.client.TraceTokenRequestFilter;
import com.proofpoint.http.client.jetty.JettyHttpClient;
import com.proofpoint.http.client.jetty.JettyIoPoolConfig;
import com.proofpoint.log.Logger;
import com.proofpoint.reporting.ReportBinder;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Provider;
import org.weakref.jmx.guice.ExportBinder;

@Deprecated
public class HttpClientModule
implements Module {
    private static final Logger log = Logger.get(HttpClientModule.class);
    private final String name;
    private final Class<? extends Annotation> annotation;
    private final Binder rootBinder;
    private final boolean isPrivate;
    protected Binder binder;

    @Deprecated
    protected HttpClientModule(String name, Class<? extends Annotation> annotation) {
        this(name, annotation, null, false);
    }

    @Deprecated
    protected HttpClientModule(String name, Class<? extends Annotation> annotation, Binder rootBinder) {
        this(name, annotation, rootBinder, false);
    }

    HttpClientModule(String name, Class<? extends Annotation> annotation, Binder rootBinder, boolean isPrivate) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.annotation = Objects.requireNonNull(annotation, "annotation is null");
        this.rootBinder = rootBinder;
        this.isPrivate = isPrivate;
    }

    public final void configure(Binder binder) {
        this.binder = Objects.requireNonNull(binder, "binder is null");
        ConfigBinder.bindConfig((Binder)binder).bind(HttpClientConfig.class).annotatedWith(this.annotation).prefixedWith(this.name);
        ConfigBinder.bindConfig((Binder)this.rootBinder).bind(JettyIoPoolConfig.class);
        this.binder.bind(HttpClient.class).annotatedWith(this.annotation).toProvider((Provider)new HttpClientProvider(this.name, this.annotation)).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, HttpRequestFilter.class, this.annotation);
        if (!this.isPrivate) {
            ReportBinder.reportBinder((Binder)binder).export(HttpClient.class).annotatedWith(this.annotation);
            ExportBinder.newExporter((Binder)binder).export(HttpClient.class).annotatedWith(this.annotation).withGeneratedName();
        }
    }

    @Deprecated
    public void addAlias(Class<? extends Annotation> alias) {
        this.binder.bind(HttpClient.class).annotatedWith(alias).to(Key.get(HttpClient.class, this.annotation));
    }

    private static class HttpClientProvider
    implements Provider<HttpClient> {
        private final String name;
        private final Class<? extends Annotation> annotation;
        private Injector injector;
        private JettyHttpClient client;

        private HttpClientProvider(String name, Class<? extends Annotation> annotation) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.annotation = Objects.requireNonNull(annotation, "annotation is null");
        }

        @Inject
        public void setInjector(Injector injector) {
            this.injector = injector;
        }

        public HttpClient get() {
            Preconditions.checkState((this.client == null ? 1 : 0) != 0, (Object)"client already created");
            HttpClientConfig config = (HttpClientConfig)this.injector.getInstance(Key.get(HttpClientConfig.class, this.annotation));
            HashSet<TraceTokenRequestFilter> filters = new HashSet<TraceTokenRequestFilter>((Collection)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<HttpRequestFilter>>(){}, this.annotation)));
            HttpClientBindOptions httpClientBindOptions = (HttpClientBindOptions)this.injector.getInstance(Key.get(HttpClientBindOptions.class, this.annotation));
            if (httpClientBindOptions.isWithTracing()) {
                filters.add(new TraceTokenRequestFilter());
            }
            this.client = new JettyHttpClient(this.name, config, filters);
            this.injector = null;
            return this.client;
        }

        @PreDestroy
        public void destroy() {
            this.client.close();
        }
    }
}

