/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.client;

import com.google.common.base.Preconditions;
import com.proofpoint.http.client.BodySource;
import com.proofpoint.http.client.LimitedRetryable;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;

public class InputStreamBodySource
implements BodySource,
LimitedRetryable {
    private final InputStream inputStream;
    private final AtomicBoolean consumed = new AtomicBoolean(false);
    private final int bufferSize;

    public InputStreamBodySource(InputStream inputStream) {
        this(inputStream, 4096);
    }

    public InputStreamBodySource(final InputStream inputStream, int bufferSize) {
        this.bufferSize = bufferSize;
        this.inputStream = new InputStream(){
            public boolean firstCall = true;

            @Override
            public int read() throws IOException {
                this.setConsumed();
                return inputStream.read();
            }

            @Override
            public int read(byte[] b) throws IOException {
                this.setConsumed();
                return inputStream.read(b);
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                this.setConsumed();
                return inputStream.read(b, off, len);
            }

            @Override
            public long skip(long n) throws IOException {
                this.setConsumed();
                return inputStream.skip(n);
            }

            @Override
            public int available() throws IOException {
                return inputStream.available();
            }

            @Override
            public void close() throws IOException {
                this.setConsumed();
                inputStream.close();
            }

            @Override
            public void mark(int readlimit) {
                inputStream.mark(readlimit);
            }

            @Override
            public void reset() throws IOException {
                inputStream.reset();
            }

            @Override
            public boolean markSupported() {
                return inputStream.markSupported();
            }

            private void setConsumed() {
                if (this.firstCall) {
                    this.firstCall = false;
                    InputStreamBodySource.this.consumed.set(true);
                }
            }
        };
    }

    public InputStream getInputStream() {
        Preconditions.checkState((!this.consumed.get() ? 1 : 0) != 0, (Object)"InputStream has been consumed");
        return this.inputStream;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public boolean isRetryable() {
        return !this.consumed.get();
    }
}

