/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.client;

import com.proofpoint.http.client.HttpUriBuilder;
import java.net.URI;

public class RelativeUriBuilder {
    private static final URI STARTING_URI = URI.create("http://invalid.invalid");
    private static final int STARTING_URI_LENGTH = STARTING_URI.toString().length();
    private HttpUriBuilder delegate;

    private RelativeUriBuilder() {
        this.delegate = HttpUriBuilder.uriBuilderFrom(STARTING_URI);
    }

    private RelativeUriBuilder(URI previous) {
        this.delegate = HttpUriBuilder.uriBuilderFrom(previous).scheme("http").host("invalid.invalid").defaultPort();
    }

    public static RelativeUriBuilder relativeUriBuilder() {
        return new RelativeUriBuilder();
    }

    public static RelativeUriBuilder relativeUriBuilder(String path) {
        return RelativeUriBuilder.relativeUriBuilder().replacePath(path);
    }

    public static RelativeUriBuilder relativeUriBuilderFrom(URI uri) {
        return new RelativeUriBuilder(uri);
    }

    public RelativeUriBuilder replacePath(String path) {
        this.delegate = this.delegate.replacePath(path);
        return this;
    }

    public RelativeUriBuilder appendPath(String path) {
        this.delegate = this.delegate.appendPath(path);
        return this;
    }

    public RelativeUriBuilder replaceParameter(String name, String ... values) {
        this.delegate = this.delegate.replaceParameter(name, values);
        return this;
    }

    public RelativeUriBuilder replaceParameter(String name, Iterable<String> values) {
        this.delegate = this.delegate.replaceParameter(name, values);
        return this;
    }

    public RelativeUriBuilder addParameter(String name, String ... values) {
        this.delegate = this.delegate.addParameter(name, values);
        return this;
    }

    public RelativeUriBuilder addParameter(String name, Iterable<String> values) {
        this.delegate = this.delegate.addParameter(name, values);
        return this;
    }

    public RelativeUriBuilder replaceRawQuery(String rawQuery) {
        this.delegate = this.delegate.replaceRawQuery(rawQuery);
        return this;
    }

    public String toString() {
        String s = this.delegate.toString().substring(STARTING_URI_LENGTH);
        while (s.startsWith("/")) {
            s = s.substring(1);
        }
        return s;
    }

    public URI build() {
        return STARTING_URI.relativize(this.delegate.build());
    }
}

