/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.client;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.proofpoint.http.client.BodySource;
import com.proofpoint.http.client.StaticBodyGenerator;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class Request {
    private final URI uri;
    private final String method;
    private final ListMultimap<String, String> headers;
    private final BodySource bodySource;
    private final boolean followRedirects;
    private final boolean preserveAuthorizationOnRedirect;

    @Deprecated
    public Request(URI uri, String method, ListMultimap<String, String> headers, @Nullable BodySource bodySource) {
        this(uri, method, headers, bodySource, false);
    }

    @Deprecated
    public Request(URI uri, String method, ListMultimap<String, String> headers, @Nullable BodySource bodySource, boolean followRedirects) {
        this(uri, method, headers, bodySource, followRedirects, false);
    }

    private Request(URI uri, String method, ListMultimap<String, String> headers, @Nullable BodySource bodySource, boolean followRedirects, boolean preserveAuthorizationOnRedirect) {
        Objects.requireNonNull(uri, "uri is null");
        Objects.requireNonNull(method, "method is null");
        this.uri = Request.validateUri(uri);
        this.method = method;
        this.headers = ImmutableListMultimap.copyOf(headers);
        this.bodySource = bodySource;
        this.followRedirects = followRedirects;
        this.preserveAuthorizationOnRedirect = preserveAuthorizationOnRedirect;
    }

    public static Builder builder() {
        return new Builder();
    }

    public URI getUri() {
        return this.uri;
    }

    public String getMethod() {
        return this.method;
    }

    public String getHeader(String name) {
        List values = this.headers.get((Object)name);
        if (values != null && !values.isEmpty()) {
            return (String)values.get(0);
        }
        return null;
    }

    public ListMultimap<String, String> getHeaders() {
        return this.headers;
    }

    public BodySource getBodySource() {
        return this.bodySource;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public boolean isPreserveAuthorizationOnRedirect() {
        return this.preserveAuthorizationOnRedirect;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("uri", (Object)this.uri).add("method", (Object)this.method).add("headers", this.headers).add("bodySource", (Object)this.bodySource).add("followRedirects", this.followRedirects).add("preserveAuthorizationOnRedirect", this.preserveAuthorizationOnRedirect).toString();
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.method, this.headers, this.bodySource, this.followRedirects, this.preserveAuthorizationOnRedirect);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Request)) {
            return false;
        }
        Request r = (Request)obj;
        return Objects.equals(this.uri, r.uri) && Objects.equals(this.method, r.method) && Objects.equals(this.headers, r.headers) && Objects.equals(this.bodySource, r.bodySource) && Objects.equals(this.followRedirects, r.followRedirects) && Objects.equals(this.preserveAuthorizationOnRedirect, r.preserveAuthorizationOnRedirect);
    }

    private static URI validateUri(URI uri) {
        if (uri.getScheme() != null) {
            Preconditions.checkArgument((uri.getHost() != null ? 1 : 0) != 0, (String)"uri does not have a host: %s", (Object)uri);
            String scheme = uri.getScheme().toLowerCase();
            Preconditions.checkArgument(("http".equals(scheme) || "https".equals(scheme) ? 1 : 0) != 0, (String)"uri scheme must be http or https: %s", (Object)uri);
        }
        Preconditions.checkArgument((uri.getPort() != 0 ? 1 : 0) != 0, (Object)"Cannot make requests to HTTP port 0");
        return uri;
    }

    public static class Builder {
        private URI uri;
        private String method;
        private final ListMultimap<String, String> headers = ArrayListMultimap.create();
        private BodySource bodySource;
        private boolean followRedirects = false;
        private boolean preserveAuthorizationOnRedirect;

        public static Builder prepareHead() {
            return new Builder().setMethod("HEAD");
        }

        public static Builder prepareGet() {
            return new Builder().setMethod("GET");
        }

        public static Builder preparePost() {
            return new Builder().setMethod("POST");
        }

        public static Builder preparePut() {
            return new Builder().setMethod("PUT");
        }

        public static Builder prepareDelete() {
            return new Builder().setMethod("DELETE");
        }

        public static Builder fromRequest(Request request) {
            return new Builder().setUri(request.getUri()).setMethod(request.getMethod()).addHeaders((Multimap<String, String>)request.getHeaders()).setBodySource(request.getBodySource()).setFollowRedirects(request.isFollowRedirects()).setPreserveAuthorizationOnRedirect(request.isPreserveAuthorizationOnRedirect());
        }

        public Builder setUri(URI uri) {
            this.uri = Request.validateUri(uri);
            return this;
        }

        public Builder setMethod(String method) {
            this.method = method;
            return this;
        }

        public Builder setHeader(String name, String value) {
            this.headers.removeAll((Object)name);
            this.headers.put((Object)name, (Object)value);
            return this;
        }

        public Builder addHeader(String name, String value) {
            this.headers.put((Object)name, (Object)value);
            return this;
        }

        public Builder addHeaders(Multimap<String, String> headers) {
            this.headers.putAll(headers);
            return this;
        }

        public Builder setBodySource(BodySource bodySource) {
            this.bodySource = bodySource;
            return this;
        }

        @Deprecated
        public Builder setBodyGenerator(StaticBodyGenerator bodyGenerator) {
            this.bodySource = bodyGenerator;
            return this;
        }

        public Builder setFollowRedirects(boolean followRedirects) {
            this.followRedirects = followRedirects;
            return this;
        }

        public Builder setPreserveAuthorizationOnRedirect(boolean preserveAuthorizationOnRedirect) {
            this.preserveAuthorizationOnRedirect = preserveAuthorizationOnRedirect;
            return this;
        }

        public Request build() {
            return new Request(this.uri, this.method, this.headers, this.bodySource, this.followRedirects, this.preserveAuthorizationOnRedirect);
        }
    }
}

