/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.client;

import com.proofpoint.stats.DistributionStat;
import com.proofpoint.stats.TimeStat;
import com.proofpoint.units.Duration;
import javax.inject.Inject;
import org.weakref.jmx.Nested;

public class RequestStats {
    private final TimeStat requestTime = new TimeStat();
    private final TimeStat responseTime = new TimeStat();
    private final DistributionStat readBytes = new DistributionStat();
    private final DistributionStat writtenBytes = new DistributionStat();

    @Inject
    public RequestStats() {
    }

    public void record(String method, int responseCode, long requestSizeInBytes, long responseSizeInBytes, Duration requestProcessingTime, Duration responseProcessingTime) {
        this.requestTime.add(requestProcessingTime);
        this.responseTime.add(responseProcessingTime);
        this.readBytes.add(responseSizeInBytes);
        this.writtenBytes.add(requestSizeInBytes);
    }

    @Nested
    public TimeStat getRequestTime() {
        return this.requestTime;
    }

    @Nested
    public TimeStat getResponseTime() {
        return this.responseTime;
    }

    @Nested
    public DistributionStat getReadBytes() {
        return this.readBytes;
    }

    @Nested
    public DistributionStat getWrittenBytes() {
        return this.writtenBytes;
    }
}

