/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.client;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.proofpoint.http.client.StaticBodyGenerator;
import com.proofpoint.json.JsonCodec;
import com.proofpoint.json.ObjectMapperProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;

public class SmileBodyGenerator<T>
extends StaticBodyGenerator {
    private static final java.util.function.Supplier<ObjectMapper> OBJECT_MAPPER_SUPPLIER = () -> ((Supplier)Suppliers.memoize(() -> new ObjectMapperProvider().get())).get();

    public static <T> SmileBodyGenerator<T> smileBodyGenerator(JsonCodec<T> jsonCodec, T instance) {
        SmileGenerator jsonGenerator;
        ObjectMapper objectMapper = OBJECT_MAPPER_SUPPLIER.get();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            jsonGenerator = new SmileFactory().createGenerator((OutputStream)out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Type genericType = jsonCodec.getType();
        JavaType rootType = null;
        if (genericType != null && instance != null && genericType.getClass() != Class.class && (rootType = objectMapper.getTypeFactory().constructType(genericType)).getRawClass() == Object.class) {
            rootType = null;
        }
        try {
            if (rootType != null) {
                objectMapper.writerFor(rootType).writeValue((JsonGenerator)jsonGenerator, instance);
            } else {
                objectMapper.writeValue((JsonGenerator)jsonGenerator, instance);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("%s could not be converted to SMILE", instance == null ? "null" : instance.getClass().getName()), e);
        }
        return new SmileBodyGenerator<T>(out.toByteArray());
    }

    private SmileBodyGenerator(byte[] body) {
        super(body);
    }
}

