/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.client;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.dataformat.smile.SmileParser;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.MediaType;
import com.google.common.primitives.Ints;
import com.proofpoint.http.client.Request;
import com.proofpoint.http.client.Response;
import com.proofpoint.http.client.ResponseHandler;
import com.proofpoint.http.client.ResponseHandlerUtils;
import com.proofpoint.http.client.UnexpectedResponseException;
import com.proofpoint.json.JsonCodec;
import com.proofpoint.json.ObjectMapperProvider;
import java.io.IOException;
import java.util.Set;

public class SmileResponseHandler<T>
implements ResponseHandler<T, RuntimeException> {
    private static final MediaType MEDIA_TYPE_SMILE = MediaType.create((String)"application", (String)"x-jackson-smile");
    private static final java.util.function.Supplier<ObjectMapper> OBJECT_MAPPER_SUPPLIER = () -> ((Supplier)Suppliers.memoize(() -> new ObjectMapperProvider().get())).get();
    private final JsonCodec<T> jsonCodec;
    private final Set<Integer> successfulResponseCodes;

    public static <T> SmileResponseHandler<T> createSmileResponseHandler(JsonCodec<T> jsonCodec) {
        return new SmileResponseHandler<T>(jsonCodec);
    }

    public static <T> SmileResponseHandler<T> createSmileResponseHandler(JsonCodec<T> jsonCodec, int firstSuccessfulResponseCode, int ... otherSuccessfulResponseCodes) {
        return new SmileResponseHandler<T>(jsonCodec, firstSuccessfulResponseCode, otherSuccessfulResponseCodes);
    }

    private SmileResponseHandler(JsonCodec<T> jsonCodec) {
        this(jsonCodec, 200, 201, 202, 203, 204, 205, 206);
    }

    private SmileResponseHandler(JsonCodec<T> jsonCodec, int firstSuccessfulResponseCode, int ... otherSuccessfulResponseCodes) {
        this.jsonCodec = jsonCodec;
        this.successfulResponseCodes = ImmutableSet.builder().add((Object)firstSuccessfulResponseCode).addAll((Iterable)Ints.asList((int[])otherSuccessfulResponseCodes)).build();
    }

    @Override
    public T handleException(Request request, Exception exception) {
        throw ResponseHandlerUtils.propagate(request, exception);
    }

    @Override
    public T handle(Request request, Response response) {
        if (!this.successfulResponseCodes.contains(response.getStatusCode())) {
            throw new UnexpectedResponseException(String.format("Expected response code to be %s, but was %d: %s", this.successfulResponseCodes, response.getStatusCode(), response.getStatusMessage()), request, response);
        }
        String contentType = response.getHeader("Content-Type");
        if (contentType == null) {
            throw new UnexpectedResponseException("Content-Type is not set for response", request, response);
        }
        if (!MediaType.parse((String)contentType).is(MEDIA_TYPE_SMILE)) {
            throw new UnexpectedResponseException("Expected application/x-jackson-smile response from server but got " + contentType, request, response);
        }
        try {
            SmileParser jsonParser = new SmileFactory().createParser(response.getInputStream());
            ObjectMapper objectMapper = OBJECT_MAPPER_SUPPLIER.get();
            jsonParser.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
            return (T)objectMapper.readValue((JsonParser)jsonParser, objectMapper.getTypeFactory().constructType(this.jsonCodec.getType()));
        }
        catch (InvalidFormatException e) {
            throw new IllegalArgumentException("Unable to create " + this.jsonCodec.getType() + " from SMILE response", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading SMILE response from server", e);
        }
    }
}

