/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.proofpoint.http.client.balancing.HttpServiceBalancer;
import com.proofpoint.http.client.balancing.HttpServiceBalancerConfig;
import com.proofpoint.http.client.balancing.HttpServiceBalancerImpl;
import com.proofpoint.http.client.balancing.HttpServiceBalancerStats;
import com.proofpoint.reporting.ReportCollectionFactory;
import com.proofpoint.reporting.ReportExporter;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;

class StaticHttpServiceBalancerProvider
implements Provider<HttpServiceBalancer> {
    private final String type;
    private final Multiset<URI> baseUris;
    private final Key<HttpServiceBalancerConfig> balancerConfigKey;
    private ReportExporter reportExporter;
    private ReportCollectionFactory reportCollectionFactory;
    private Injector injector;

    StaticHttpServiceBalancerProvider(String type, Collection<URI> baseUris, Key<HttpServiceBalancerConfig> balancerConfigKey) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.baseUris = ImmutableMultiset.copyOf(baseUris);
        this.balancerConfigKey = Objects.requireNonNull(balancerConfigKey, "balancerConfigKey is null");
    }

    @Inject
    public void setReportExporter(ReportExporter reportExporter) {
        Objects.requireNonNull(reportExporter, "reportExporter is null");
        this.reportExporter = reportExporter;
    }

    @Inject
    public void setReportCollectionFactory(ReportCollectionFactory reportCollectionFactory) {
        Objects.requireNonNull(reportCollectionFactory, "reportCollectionFactory is null");
        this.reportCollectionFactory = reportCollectionFactory;
    }

    @Inject
    public void setInjector(Injector injector) {
        Objects.requireNonNull(injector, "injector is null");
        this.injector = injector;
    }

    public HttpServiceBalancer get() {
        Objects.requireNonNull(this.type, "type is null");
        Objects.requireNonNull(this.baseUris, "baseUris is null");
        ImmutableMap tags = ImmutableMap.of((Object)"serviceType", (Object)this.type);
        HttpServiceBalancerStats httpServiceBalancerStats = (HttpServiceBalancerStats)this.reportCollectionFactory.createReportCollection(HttpServiceBalancerStats.class, false, "ServiceClient", (Map)tags);
        HttpServiceBalancerImpl balancer = new HttpServiceBalancerImpl(String.format("type=[%s], static", this.type), httpServiceBalancerStats, (HttpServiceBalancerConfig)this.injector.getInstance(this.balancerConfigKey));
        this.reportExporter.export((Object)balancer, false, "ServiceClient", (Map)tags);
        balancer.updateHttpUris((Collection<URI>)this.baseUris);
        return balancer;
    }
}

