/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.client;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.proofpoint.http.client.HeaderName;
import com.proofpoint.http.client.Request;
import com.proofpoint.http.client.Response;
import com.proofpoint.http.client.ResponseHandler;
import com.proofpoint.http.client.ResponseHandlerUtils;
import java.util.List;
import javax.annotation.Nullable;

public class StatusResponseHandler
implements ResponseHandler<StatusResponse, RuntimeException> {
    private static final StatusResponseHandler statusResponseHandler = new StatusResponseHandler();

    public static StatusResponseHandler createStatusResponseHandler() {
        return statusResponseHandler;
    }

    private StatusResponseHandler() {
    }

    @Override
    public StatusResponse handleException(Request request, Exception exception) {
        throw ResponseHandlerUtils.propagate(request, exception);
    }

    @Override
    public StatusResponse handle(Request request, Response response) {
        return new StatusResponse(response.getStatusCode(), response.getStatusMessage(), response.getHeaders());
    }

    public static class StatusResponse {
        private final int statusCode;
        private final String statusMessage;
        private final ListMultimap<HeaderName, String> headers;

        public StatusResponse(int statusCode, String statusMessage, ListMultimap<HeaderName, String> headers) {
            this.statusCode = statusCode;
            this.statusMessage = statusMessage;
            this.headers = ImmutableListMultimap.copyOf(headers);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getStatusMessage() {
            return this.statusMessage;
        }

        @Nullable
        public String getHeader(String name) {
            List values = this.getHeaders().get((Object)HeaderName.of(name));
            if (values.isEmpty()) {
                return null;
            }
            return (String)values.get(0);
        }

        public List<String> getHeaders(String name) {
            return this.headers.get((Object)HeaderName.of(name));
        }

        public ListMultimap<HeaderName, String> getHeaders() {
            return this.headers;
        }
    }
}

