/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.client;

import com.proofpoint.http.client.HttpRequestFilter;
import com.proofpoint.http.client.Request;
import com.proofpoint.json.JsonCodec;
import com.proofpoint.tracetoken.TraceToken;
import com.proofpoint.tracetoken.TraceTokenManager;
import java.util.Objects;

public class TraceTokenRequestFilter
implements HttpRequestFilter {
    public static final String TRACETOKEN_HEADER = "X-Proofpoint-Tracetoken";
    private static final JsonCodec<TraceToken> TRACE_TOKEN_JSON_CODEC = JsonCodec.jsonCodec(TraceToken.class).withoutPretty();

    @Override
    public Request filterRequest(Request request) {
        Objects.requireNonNull(request, "request is null");
        TraceToken token = TraceTokenManager.getCurrentTraceToken();
        if (token == null) {
            return request;
        }
        String tokenString = token.size() == 1 ? token.toString() : TRACE_TOKEN_JSON_CODEC.toJson((Object)token);
        return Request.Builder.fromRequest(request).addHeader(TRACETOKEN_HEADER, tokenString).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj != null && this.getClass() == obj.getClass();
    }

    public int hashCode() {
        return 1;
    }
}

