/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.client.balancing;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import com.proofpoint.http.client.HttpClient;
import com.proofpoint.http.client.Request;
import com.proofpoint.http.client.RequestStats;
import com.proofpoint.http.client.ResponseHandler;
import com.proofpoint.http.client.balancing.BackoffPolicy;
import com.proofpoint.http.client.balancing.BalancingHttpClientConfig;
import com.proofpoint.http.client.balancing.DecorrelatedJitteredBackoffPolicy;
import com.proofpoint.http.client.balancing.FailureStatusException;
import com.proofpoint.http.client.balancing.ForBalancingHttpClient;
import com.proofpoint.http.client.balancing.HttpServiceAttempt;
import com.proofpoint.http.client.balancing.HttpServiceBalancer;
import com.proofpoint.http.client.balancing.InnerHandlerException;
import com.proofpoint.http.client.balancing.NoRetryBudget;
import com.proofpoint.http.client.balancing.RetryBudget;
import com.proofpoint.http.client.balancing.RetryException;
import com.proofpoint.http.client.balancing.RetryingResponseHandler;
import com.proofpoint.http.client.balancing.TokenRetryBudget;
import com.proofpoint.http.client.jetty.JettyHttpClient;
import com.proofpoint.tracetoken.TraceToken;
import com.proofpoint.tracetoken.TraceTokenManager;
import com.proofpoint.tracetoken.TraceTokenScope;
import com.proofpoint.units.Duration;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;

public class BalancingHttpClient
implements HttpClient {
    private static final Duration ZERO_DURATION = new Duration(0.0, TimeUnit.MILLISECONDS);
    private final HttpServiceBalancer pool;
    private final HttpClient httpClient;
    private final int maxAttempts;
    private final RetryBudget retryBudget;
    private final BackoffPolicy backoffPolicy;
    private final ScheduledExecutorService retryExecutor;
    private final Cache<Class<? extends Exception>, Boolean> exceptionCache = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();

    @Inject
    public BalancingHttpClient(@ForBalancingHttpClient HttpServiceBalancer pool, @ForBalancingHttpClient HttpClient httpClient, BalancingHttpClientConfig config, @ForBalancingHttpClient ScheduledExecutorService retryExecutor) {
        this(pool, httpClient, config, retryExecutor, Ticker.systemTicker());
    }

    @VisibleForTesting
    BalancingHttpClient(@ForBalancingHttpClient HttpServiceBalancer pool, @ForBalancingHttpClient HttpClient httpClient, BalancingHttpClientConfig config, @ForBalancingHttpClient ScheduledExecutorService retryExecutor, Ticker ticker) {
        this.pool = Objects.requireNonNull(pool, "pool is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.maxAttempts = Objects.requireNonNull(config, "config is null").getMaxAttempts();
        this.retryBudget = TokenRetryBudget.tokenRetryBudget(config.getRetryBudgetRatio(), config.getRetryBudgetRatioPeriod(), config.getRetryBudgetMinPerSecond(), ticker);
        this.backoffPolicy = new DecorrelatedJitteredBackoffPolicy(config.getMinBackoff(), config.getMaxBackoff());
        this.retryExecutor = Objects.requireNonNull(retryExecutor, "retryExecutor is null");
    }

    @Override
    public <T, E extends Exception> T execute(Request request, ResponseHandler<T, E> responseHandler) throws E {
        HttpServiceAttempt attempt;
        Preconditions.checkArgument((!request.getUri().isAbsolute() ? 1 : 0) != 0, (Object)(request.getUri() + " is not a relative URI"));
        Preconditions.checkArgument((request.getUri().getHost() == null ? 1 : 0) != 0, (Object)(request.getUri() + " has a host component"));
        String path = request.getUri().getPath();
        Preconditions.checkArgument((path == null || !path.startsWith("/") ? 1 : 0) != 0, (Object)(request.getUri() + " path starts with '/'"));
        try {
            attempt = this.pool.createAttempt();
        }
        catch (RuntimeException e) {
            return responseHandler.handleException(request, e);
        }
        int attemptsLeft = this.maxAttempts;
        this.retryBudget.initialAttempt();
        BackoffPolicy attemptBackoffPolicy = this.backoffPolicy;
        Duration previousBackoff = ZERO_DURATION;
        RetryingResponseHandler<T, E> retryingResponseHandler = new RetryingResponseHandler<T, E>(responseHandler, this.retryBudget, this.exceptionCache);
        while (true) {
            URI uri;
            if (!(uri = attempt.getUri()).toString().endsWith("/")) {
                uri = URI.create(uri.toString() + '/');
            }
            uri = uri.resolve(request.getUri());
            Request subRequest = Request.Builder.fromRequest(request).setUri(uri).build();
            if (attemptsLeft <= 1) {
                retryingResponseHandler = new RetryingResponseHandler<T, E>(responseHandler, NoRetryBudget.INSTANCE, this.exceptionCache);
            }
            --attemptsLeft;
            try {
                T t = this.httpClient.execute(subRequest, retryingResponseHandler);
                attempt.markGood();
                return t;
            }
            catch (InnerHandlerException e) {
                attempt.markBad(e.getFailureCategory(), e.getHandlerCategory());
                throw (Exception)e.getCause();
            }
            catch (FailureStatusException e) {
                attempt.markBad(e.getFailureCategory());
                return (T)e.result;
            }
            catch (RetryException e) {
                attempt.markBad(e.getFailureCategory());
                Duration backoff = attemptBackoffPolicy.backoff(previousBackoff);
                long millis = backoff.roundTo(TimeUnit.MILLISECONDS);
                try {
                    Thread.sleep(millis);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                    return responseHandler.handleException(request, e1);
                }
                try {
                    attempt = attempt.next();
                    previousBackoff = backoff;
                    attemptBackoffPolicy = attemptBackoffPolicy.nextAttempt();
                }
                catch (RuntimeException e1) {
                    return responseHandler.handleException(request, e1);
                }
            }
        }
    }

    @Override
    public <T, E extends Exception> HttpClient.HttpResponseFuture<T> executeAsync(Request request, ResponseHandler<T, E> responseHandler) {
        HttpServiceAttempt attempt;
        Preconditions.checkArgument((!request.getUri().isAbsolute() ? 1 : 0) != 0, (Object)(request.getUri() + " is not a relative URI"));
        Preconditions.checkArgument((request.getUri().getHost() == null ? 1 : 0) != 0, (Object)(request.getUri() + " has a host component"));
        String path = request.getUri().getPath();
        Preconditions.checkArgument((path == null || !path.startsWith("/") ? 1 : 0) != 0, (Object)(request.getUri() + " path starts with '/'"));
        try {
            attempt = this.pool.createAttempt();
        }
        catch (RuntimeException e) {
            try {
                return new ImmediateHttpResponseFuture<T>(responseHandler.handleException(request, e));
            }
            catch (Exception e1) {
                return new ImmediateFailedHttpResponseFuture(e1);
            }
        }
        this.retryBudget.initialAttempt();
        RetryFuture<T, E> retryFuture = new RetryFuture<T, E>(request, responseHandler);
        this.attemptQuery(retryFuture, request, responseHandler, attempt, this.maxAttempts);
        return retryFuture;
    }

    private <T, E extends Exception> void attemptQuery(RetryFuture<T, E> retryFuture, Request request, ResponseHandler<T, E> responseHandler, HttpServiceAttempt attempt, int attemptsLeft) {
        RetryingResponseHandler<T, E> retryingResponseHandler = new RetryingResponseHandler<T, E>(responseHandler, attemptsLeft <= 1 ? NoRetryBudget.INSTANCE : this.retryBudget, this.exceptionCache);
        URI uri = attempt.getUri();
        if (!uri.toString().endsWith("/")) {
            uri = URI.create(uri.toString() + '/');
        }
        uri = uri.resolve(request.getUri());
        Request subRequest = Request.Builder.fromRequest(request).setUri(uri).build();
        HttpClient.HttpResponseFuture<T> future = this.httpClient.executeAsync(subRequest, retryingResponseHandler);
        retryFuture.newAttempt(future, attempt, uri, --attemptsLeft);
    }

    @Override
    @Flatten
    public RequestStats getStats() {
        return this.httpClient.getStats();
    }

    @Flatten
    RetryBudget getRetryBudget() {
        return this.retryBudget;
    }

    @Managed
    public String dump() {
        if (this.httpClient instanceof JettyHttpClient) {
            return ((JettyHttpClient)this.httpClient).dump();
        }
        return null;
    }

    @Managed
    public void dumpStdErr() {
        if (this.httpClient instanceof JettyHttpClient) {
            ((JettyHttpClient)this.httpClient).dumpStdErr();
        }
    }

    @Override
    public void close() {
        this.retryExecutor.shutdown();
        this.retryExecutor.shutdownNow();
        this.httpClient.close();
    }

    @Override
    public boolean isClosed() {
        return this.httpClient.isClosed();
    }

    static /* synthetic */ BackoffPolicy access$000(BalancingHttpClient x0) {
        return x0.backoffPolicy;
    }

    static /* synthetic */ Duration access$100() {
        return ZERO_DURATION;
    }

    private static class RetryDelayFuture<T>
    extends AbstractFuture<T>
    implements HttpClient.HttpResponseFuture<T> {
        private final ScheduledFuture<?> scheduledFuture;
        private final HttpServiceAttempt attempt;

        public RetryDelayFuture(ScheduledFuture<?> scheduledFuture, HttpServiceAttempt attempt) {
            this.scheduledFuture = Objects.requireNonNull(scheduledFuture, "scheduledFuture is null");
            this.attempt = Objects.requireNonNull(attempt, "attempt is null");
        }

        @Override
        public String getState() {
            return String.format("Delaying for retry after attempt %s", this.attempt);
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.scheduledFuture.cancel(mayInterruptIfRunning);
        }
    }

    private static class ImmediateFailedHttpResponseFuture<T, E extends Exception>
    extends AbstractFuture<T>
    implements HttpClient.HttpResponseFuture<T> {
        private final E exception;

        ImmediateFailedHttpResponseFuture(E exception) {
            this.exception = exception;
            this.setException((Throwable)exception);
        }

        @Override
        public String getState() {
            return "Failed with exception " + this.exception;
        }
    }

    private static class ImmediateHttpResponseFuture<T>
    extends AbstractFuture<T>
    implements HttpClient.HttpResponseFuture<T> {
        private final T result;

        ImmediateHttpResponseFuture(T result) {
            this.result = result;
            this.set(result);
        }

        @Override
        public String getState() {
            return "Succeeded with result " + this.result;
        }
    }

    private class RetryFuture<T, E extends Exception>
    extends AbstractFuture<T>
    implements HttpClient.HttpResponseFuture<T> {
        private final Request request;
        private final ResponseHandler<T, E> responseHandler;
        private final Object subFutureLock = new Object();
        @GuardedBy(value="subFutureLock")
        private HttpServiceAttempt attempt = null;
        @GuardedBy(value="subFutureLock")
        private BackoffPolicy attemptBackoffPolicy = BalancingHttpClient.access$000(BalancingHttpClient.this);
        @GuardedBy(value="subFutureLock")
        private Duration previousBackoff = BalancingHttpClient.access$100();
        @GuardedBy(value="subFutureLock")
        private URI uri = null;
        @GuardedBy(value="subFutureLock")
        private HttpClient.HttpResponseFuture<T> subFuture = null;

        RetryFuture(Request request, ResponseHandler<T, E> responseHandler) {
            this.request = request;
            this.responseHandler = responseHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void newAttempt(HttpClient.HttpResponseFuture<T> future, final HttpServiceAttempt attempt, URI uri, final int attemptsLeft) {
            Object object = this.subFutureLock;
            synchronized (object) {
                this.attempt = attempt;
                this.subFuture = future;
                this.uri = uri;
            }
            final RetryFuture retryFuture = this;
            final Request request = this.request;
            final ResponseHandler<T, E> responseHandler = this.responseHandler;
            Futures.addCallback(future, (FutureCallback)new FutureCallback<T>(){

                public void onSuccess(T result) {
                    attempt.markGood();
                    RetryFuture.this.set(result);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onFailure(Throwable t) {
                    if (t instanceof InnerHandlerException) {
                        InnerHandlerException innerHandlerException = (InnerHandlerException)t;
                        attempt.markBad(innerHandlerException.getFailureCategory(), innerHandlerException.getHandlerCategory());
                        RetryFuture.this.setException(t.getCause());
                    } else if (t instanceof FailureStatusException) {
                        attempt.markBad(((FailureStatusException)t).getFailureCategory());
                        RetryFuture.this.set(((FailureStatusException)t).result);
                    } else if (t instanceof RetryException) {
                        attempt.markBad(((RetryException)t).getFailureCategory());
                        TraceToken traceToken = TraceTokenManager.getCurrentTraceToken();
                        Object object = RetryFuture.this.subFutureLock;
                        synchronized (object) {
                            Duration backoff = RetryFuture.this.attemptBackoffPolicy.backoff(RetryFuture.this.previousBackoff);
                            ScheduledFuture<?> scheduledFuture = BalancingHttpClient.this.retryExecutor.schedule(() -> {
                                try (TraceTokenScope scope = TraceTokenManager.registerTraceToken((TraceToken)traceToken);){
                                    Object object = RetryFuture.this.subFutureLock;
                                    synchronized (object) {
                                        HttpServiceAttempt nextAttempt;
                                        try {
                                            nextAttempt = attempt.next();
                                            RetryFuture.this.previousBackoff = backoff;
                                            RetryFuture.this.attemptBackoffPolicy = RetryFuture.this.attemptBackoffPolicy.nextAttempt();
                                        }
                                        catch (RuntimeException e1) {
                                            try {
                                                RetryFuture.this.set(responseHandler.handleException(request, e1));
                                            }
                                            catch (Exception e2) {
                                                RetryFuture.this.setException(e2);
                                            }
                                            if (scope != null) {
                                                if (var9_9 != null) {
                                                    try {
                                                        scope.close();
                                                    }
                                                    catch (Throwable throwable) {
                                                        var9_9.addSuppressed(throwable);
                                                    }
                                                } else {
                                                    scope.close();
                                                }
                                            }
                                            return;
                                        }
                                        try {
                                            BalancingHttpClient.this.attemptQuery(retryFuture, request, responseHandler, nextAttempt, attemptsLeft);
                                        }
                                        catch (RuntimeException e1) {
                                            RetryFuture.this.setException(e1);
                                        }
                                    }
                                }
                            }, backoff.roundTo(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
                            RetryFuture.this.subFuture = new RetryDelayFuture(scheduledFuture, attempt);
                        }
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (super.cancel(mayInterruptIfRunning)) {
                Object object = this.subFutureLock;
                synchronized (object) {
                    this.subFuture.cancel(mayInterruptIfRunning);
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getState() {
            Object object = this.subFutureLock;
            synchronized (object) {
                return String.format("Attempt %s to %s: %s", this.attempt, this.uri, this.subFuture.getState());
            }
        }
    }
}

