/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.client.balancing;

import com.proofpoint.configuration.Config;
import com.proofpoint.configuration.ConfigDescription;
import com.proofpoint.units.Duration;
import com.proofpoint.units.MaxDuration;
import com.proofpoint.units.MinDuration;
import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

public class BalancingHttpClientConfig {
    private int maxAttempts = 3;
    private Duration minBackoff = new Duration(10.0, TimeUnit.MILLISECONDS);
    private Duration maxBackoff = new Duration(10.0, TimeUnit.SECONDS);
    private BigDecimal retryBudgetRatio = new BigDecimal(2).movePointLeft(1);
    private Duration retryBudgetRatioPeriod = new Duration(10.0, TimeUnit.SECONDS);
    private int retryBudgetMinPerSecond = 10;

    @Min(value=1L)
    public @Min(value=1L) int getMaxAttempts() {
        return this.maxAttempts;
    }

    @Config(value="http-client.max-attempts")
    public BalancingHttpClientConfig setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
        return this;
    }

    public Duration getMinBackoff() {
        return this.minBackoff;
    }

    @Config(value="http-client.min-backoff")
    @ConfigDescription(value="Minimum backoff delay before a retry")
    public BalancingHttpClientConfig setMinBackoff(Duration minBackoff) {
        this.minBackoff = minBackoff;
        return this;
    }

    public Duration getMaxBackoff() {
        return this.maxBackoff;
    }

    @Config(value="http-client.max-backoff")
    @ConfigDescription(value="Maximum backoff delay before a retry")
    public BalancingHttpClientConfig setMaxBackoff(Duration maxBackoff) {
        this.maxBackoff = maxBackoff;
        return this;
    }

    @Min(value=0L)
    @Max(value=1000L)
    public @Min(value=0L) @Max(value=1000L) BigDecimal getRetryBudgetRatio() {
        return this.retryBudgetRatio;
    }

    @Config(value="http-client.retry-budget.ratio")
    @ConfigDescription(value="The ratio of permitted retries to initial requests")
    public BalancingHttpClientConfig setRetryBudgetRatio(BigDecimal retryBudgetRatio) {
        this.retryBudgetRatio = retryBudgetRatio;
        return this;
    }

    @MinDuration(value="1s")
    @MaxDuration(value="60s")
    public Duration getRetryBudgetRatioPeriod() {
        return this.retryBudgetRatioPeriod;
    }

    @Config(value="http-client.retry-budget.ratio-period")
    @ConfigDescription(value="The time over which initial requests are considered when calculating retry budgets")
    public BalancingHttpClientConfig setRetryBudgetRatioPeriod(Duration retryBudgetRatioPeriod) {
        this.retryBudgetRatioPeriod = retryBudgetRatioPeriod;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getRetryBudgetMinPerSecond() {
        return this.retryBudgetMinPerSecond;
    }

    @Config(value="http-client.retry-budget.min-per-second")
    @ConfigDescription(value="Additional number of retries permitted per second")
    public BalancingHttpClientConfig setRetryBudgetMinPerSecond(int retryBudgetMinPerSecond) {
        this.retryBudgetMinPerSecond = retryBudgetMinPerSecond;
        return this;
    }

    @AssertFalse
    public boolean isMaxBackoffLessThanMinBackoff() {
        return this.maxBackoff.compareTo(this.minBackoff) < 0;
    }
}

