/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.client.balancing;

import com.google.common.base.Preconditions;
import com.proofpoint.http.client.balancing.BackoffPolicy;
import com.proofpoint.units.Duration;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;

class DecorrelatedJitteredBackoffPolicy
implements BackoffPolicy {
    private final long min;
    private final long max;

    public DecorrelatedJitteredBackoffPolicy(Duration min, Duration max) {
        this.min = min.roundTo(TimeUnit.NANOSECONDS);
        this.max = max.roundTo(TimeUnit.NANOSECONDS);
        Preconditions.checkArgument((this.min <= this.max ? 1 : 0) != 0, (Object)"min is greater than max");
    }

    @Override
    public BackoffPolicy nextAttempt() {
        return this;
    }

    @Override
    public Duration backoff(Duration previousBackoff) {
        long prev = previousBackoff.roundTo(TimeUnit.NANOSECONDS);
        long range = Math.abs(prev * 3L - this.min);
        long randBackoff = range == 0L ? this.min : this.min + ThreadLocalRandom.current().nextLong(range);
        long backoff = Math.min(this.max, randBackoff);
        return new Duration((double)backoff, TimeUnit.NANOSECONDS);
    }
}

