/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.client.balancing;

import com.proofpoint.configuration.Config;
import com.proofpoint.configuration.ConfigDescription;
import com.proofpoint.units.Duration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.Min;

public class HttpServiceBalancerConfig {
    private int consecutiveFailures = 5;
    private Duration minBackoff = new Duration(5.0, TimeUnit.SECONDS);
    private Duration maxBackoff = new Duration(2.0, TimeUnit.MINUTES);

    @Min(value=1L)
    public @Min(value=1L) int getConsecutiveFailures() {
        return this.consecutiveFailures;
    }

    @Config(value="consecutive-failures")
    @ConfigDescription(value="Number of consecutive failures before a URI is marked dead")
    public HttpServiceBalancerConfig setConsecutiveFailures(int consecutiveFailures) {
        this.consecutiveFailures = consecutiveFailures;
        return this;
    }

    public Duration getMinBackoff() {
        return this.minBackoff;
    }

    @Config(value="min-backoff")
    @ConfigDescription(value="Minimum backoff delay before probing a dead URI")
    public HttpServiceBalancerConfig setMinBackoff(Duration minBackoff) {
        this.minBackoff = minBackoff;
        return this;
    }

    public Duration getMaxBackoff() {
        return this.maxBackoff;
    }

    @Config(value="max-backoff")
    @ConfigDescription(value="Maximum backoff delay before probing a dead URI")
    public HttpServiceBalancerConfig setMaxBackoff(Duration maxBackoff) {
        this.maxBackoff = maxBackoff;
        return this;
    }

    @AssertFalse
    public boolean isMaxBackoffLessThanMinBackoff() {
        return this.maxBackoff.compareTo(this.minBackoff) < 0;
    }
}

