/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.client.balancing;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import com.proofpoint.http.client.balancing.BackoffPolicy;
import com.proofpoint.http.client.balancing.DecorrelatedJitteredBackoffPolicy;
import com.proofpoint.http.client.balancing.HttpServiceAttempt;
import com.proofpoint.http.client.balancing.HttpServiceBalancer;
import com.proofpoint.http.client.balancing.HttpServiceBalancerConfig;
import com.proofpoint.http.client.balancing.HttpServiceBalancerStats;
import com.proofpoint.http.client.balancing.ServiceUnavailableException;
import com.proofpoint.stats.MaxGauge;
import com.proofpoint.units.Duration;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import org.weakref.jmx.Nested;

public class HttpServiceBalancerImpl
implements HttpServiceBalancer {
    private static final InstanceState INSTANCE_STATE_WORST = new InstanceState(Liveness.DEAD, Integer.MAX_VALUE);
    private static final Duration ZERO_DURATION = new Duration(0.0, TimeUnit.SECONDS);
    private final AtomicReference<ImmutableMultiset<URI>> httpUris = new AtomicReference<ImmutableMultiset>(ImmutableMultiset.of());
    @GuardedBy(value="uriStates")
    private final Map<URI, InstanceState> uriStates = new HashMap<URI, InstanceState>();
    private final String description;
    private final HttpServiceBalancerStats httpServiceBalancerStats;
    private final int consecutiveFailures;
    private final BackoffPolicy backoffPolicy;
    private final Ticker ticker;
    private final MaxGauge concurrency = new MaxGauge();

    public HttpServiceBalancerImpl(String description, HttpServiceBalancerStats httpServiceBalancerStats, HttpServiceBalancerConfig config) {
        this(description, httpServiceBalancerStats, config, Ticker.systemTicker());
    }

    HttpServiceBalancerImpl(String description, HttpServiceBalancerStats httpServiceBalancerStats, HttpServiceBalancerConfig config, Ticker ticker) {
        this.description = Objects.requireNonNull(description, "description is null");
        this.httpServiceBalancerStats = Objects.requireNonNull(httpServiceBalancerStats, "httpServiceBalancerStats is null");
        this.consecutiveFailures = Objects.requireNonNull(config, "config is null").getConsecutiveFailures();
        this.backoffPolicy = new DecorrelatedJitteredBackoffPolicy(config.getMinBackoff(), config.getMaxBackoff());
        this.ticker = Objects.requireNonNull(ticker, "ticker is null");
    }

    @Override
    public HttpServiceAttempt createAttempt() {
        return new HttpServiceAttemptImpl((Set<URI>)ImmutableSet.of());
    }

    @Beta
    public void updateHttpUris(Collection<URI> newHttpUris) {
        this.httpUris.set((ImmutableMultiset<URI>)ImmutableMultiset.copyOf(newHttpUris));
    }

    @Nested
    public MaxGauge getConcurrency() {
        return this.concurrency;
    }

    private static enum Liveness {
        ALIVE{

            @Override
            public void mark(boolean isFailure, InstanceState uriState, HttpServiceAttemptImpl attempt, HttpServiceBalancerImpl balancer) {
                if (isFailure) {
                    if (++uriState.numFailures >= balancer.consecutiveFailures) {
                        uriState.liveness = DEAD;
                        uriState.backoffPolicy = balancer.backoffPolicy;
                        uriState.lastBackoff = uriState.backoffPolicy.backoff(ZERO_DURATION);
                        uriState.deadUntil = balancer.ticker.read() + uriState.lastBackoff.roundTo(TimeUnit.NANOSECONDS);
                        balancer.httpServiceBalancerStats.removal(attempt.uri).add(uriState.lastBackoff);
                    }
                } else {
                    uriState.numFailures = 0;
                }
            }
        }
        ,
        DEAD{

            @Override
            public void mark(boolean isFailure, InstanceState uriState, HttpServiceAttemptImpl attempt, HttpServiceBalancerImpl balancer) {
                if (!isFailure) {
                    uriState.liveness = ALIVE;
                    uriState.numFailures = 0;
                    uriState.backoffPolicy = null;
                    uriState.lastBackoff = null;
                    balancer.httpServiceBalancerStats.revival(attempt.uri).add(1L);
                }
            }
        }
        ,
        PROBING{

            @Override
            public void mark(boolean isFailure, InstanceState uriState, HttpServiceAttemptImpl attempt, HttpServiceBalancerImpl balancer) {
                if (isFailure) {
                    uriState.liveness = DEAD;
                    uriState.backoffPolicy = uriState.backoffPolicy.nextAttempt();
                    uriState.lastBackoff = uriState.backoffPolicy.backoff(uriState.lastBackoff);
                    uriState.deadUntil = balancer.ticker.read() + uriState.lastBackoff.roundTo(TimeUnit.NANOSECONDS);
                    balancer.httpServiceBalancerStats.removal(attempt.uri).add(uriState.lastBackoff);
                } else {
                    uriState.liveness = ALIVE;
                    uriState.numFailures = 0;
                    uriState.backoffPolicy = null;
                    uriState.lastBackoff = null;
                    balancer.httpServiceBalancerStats.revival(attempt.uri).add(1L);
                }
            }
        };


        public abstract void mark(boolean var1, InstanceState var2, HttpServiceAttemptImpl var3, HttpServiceBalancerImpl var4);
    }

    private static class InstanceState {
        Liveness liveness;
        int weight = 1;
        int concurrency;
        int numFailures = 0;
        BackoffPolicy backoffPolicy;
        Duration lastBackoff;
        long deadUntil;

        InstanceState(Liveness liveness, int concurrency) {
            this.liveness = liveness;
            this.concurrency = concurrency;
        }

        int compareTo(InstanceState that) {
            if (this.liveness == Liveness.DEAD || this.liveness == Liveness.PROBING && this.concurrency > 0) {
                if (that.liveness == Liveness.DEAD || that.liveness == Liveness.PROBING && that.concurrency > 0) {
                    return Integer.compare(this.concurrency / this.weight, that.concurrency / that.weight);
                }
                return 1;
            }
            if (that.liveness == Liveness.DEAD || that.liveness == Liveness.PROBING && that.concurrency > 0) {
                return -1;
            }
            return Integer.compare(this.concurrency / this.weight, that.concurrency / that.weight);
        }
    }

    private class HttpServiceAttemptImpl
    implements HttpServiceAttempt {
        private final Set<URI> attempted;
        private final URI uri;
        private final long startTick;
        private boolean inProgress = true;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        HttpServiceAttemptImpl(Set<URI> attempted) {
            ImmutableSet attemptedCopy = attempted;
            Multiset httpUris = (Multiset)((ImmutableMultiset)HttpServiceBalancerImpl.this.httpUris.get()).stream().filter(uri -> !attemptedCopy.contains(uri)).collect(Collectors.toCollection(HashMultiset::create));
            if (httpUris.isEmpty()) {
                httpUris = (Multiset)HttpServiceBalancerImpl.this.httpUris.get();
                attempted = ImmutableSet.of();
                if (httpUris.isEmpty()) {
                    throw new ServiceUnavailableException(HttpServiceBalancerImpl.this.description);
                }
            }
            InstanceState bestState = INSTANCE_STATE_WORST;
            ArrayList<URI> leastUris = new ArrayList<URI>();
            Map map = HttpServiceBalancerImpl.this.uriStates;
            synchronized (map) {
                long now = HttpServiceBalancerImpl.this.ticker.read();
                while (true) {
                    for (Multiset.Entry uriEntry : httpUris.entrySet()) {
                        int comparison;
                        URI uri2 = (URI)uriEntry.getElement();
                        InstanceState uriState = HttpServiceBalancerImpl.this.uriStates.computeIfAbsent(uri2, k -> new InstanceState(Liveness.ALIVE, 0));
                        if (uriState.weight != uriEntry.getCount()) {
                            uriState.weight = uriEntry.getCount();
                        }
                        if (uriState.liveness == Liveness.DEAD && uriState.deadUntil <= now) {
                            uriState.liveness = Liveness.PROBING;
                        }
                        if ((comparison = uriState.compareTo(bestState)) > 0) continue;
                        if (comparison < 0) {
                            bestState = uriState;
                            leastUris = new ArrayList();
                        }
                        for (int i = uriState.weight - uriState.concurrency % uriState.weight; i > 0; --i) {
                            leastUris.add(uri2);
                        }
                    }
                    if (bestState.liveness != Liveness.DEAD || attempted.isEmpty()) break;
                    httpUris = (Multiset)HttpServiceBalancerImpl.this.httpUris.get();
                    attempted = ImmutableSet.of();
                }
                this.uri = (URI)leastUris.get(ThreadLocalRandom.current().nextInt(0, leastUris.size()));
                InstanceState uriState = (InstanceState)HttpServiceBalancerImpl.this.uriStates.get(this.uri);
                if (uriState.liveness == Liveness.PROBING && uriState.concurrency == 0) {
                    HttpServiceBalancerImpl.this.httpServiceBalancerStats.probe(this.uri).add(1L);
                }
                if ((long)uriState.concurrency++ == HttpServiceBalancerImpl.this.concurrency.get()) {
                    HttpServiceBalancerImpl.this.concurrency.update((long)uriState.concurrency);
                }
            }
            this.attempted = ImmutableSet.copyOf((Collection)attempted);
            this.startTick = HttpServiceBalancerImpl.this.ticker.read();
        }

        @Override
        public URI getUri() {
            return this.uri;
        }

        @Override
        public void markGood() {
            this.decrementConcurrency(false);
            HttpServiceBalancerImpl.this.httpServiceBalancerStats.requestTime(this.uri, HttpServiceBalancerStats.Status.SUCCESS).add(HttpServiceBalancerImpl.this.ticker.read() - this.startTick, TimeUnit.NANOSECONDS);
        }

        @Override
        public void markBad(String failureCategory) {
            this.decrementConcurrency(true);
            HttpServiceBalancerImpl.this.httpServiceBalancerStats.requestTime(this.uri, HttpServiceBalancerStats.Status.FAILURE).add(HttpServiceBalancerImpl.this.ticker.read() - this.startTick, TimeUnit.NANOSECONDS);
            HttpServiceBalancerImpl.this.httpServiceBalancerStats.failure(this.uri, failureCategory).add(1L);
        }

        @Override
        public void markBad(String failureCategory, String handlerCategory) {
            this.decrementConcurrency(true);
            HttpServiceBalancerImpl.this.httpServiceBalancerStats.requestTime(this.uri, HttpServiceBalancerStats.Status.FAILURE).add(HttpServiceBalancerImpl.this.ticker.read() - this.startTick, TimeUnit.NANOSECONDS);
            HttpServiceBalancerImpl.this.httpServiceBalancerStats.failure(this.uri, failureCategory, handlerCategory).add(1L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void decrementConcurrency(boolean isFailure) {
            Preconditions.checkState((boolean)this.inProgress, (Object)"is in progress");
            this.inProgress = false;
            Map map = HttpServiceBalancerImpl.this.uriStates;
            synchronized (map) {
                InstanceState uriState = (InstanceState)HttpServiceBalancerImpl.this.uriStates.get(this.uri);
                uriState.liveness.mark(isFailure, uriState, this, HttpServiceBalancerImpl.this);
                int oldConcurrency = uriState.concurrency--;
                if (oldConcurrency > 0) {
                    // empty if block
                }
                if (oldConcurrency == 1 && !isFailure && uriState.liveness == Liveness.ALIVE) {
                    HttpServiceBalancerImpl.this.uriStates.remove(this.uri);
                    if (HttpServiceBalancerImpl.this.uriStates.isEmpty()) {
                        HttpServiceBalancerImpl.this.concurrency.update(0L);
                        return;
                    }
                }
                if (HttpServiceBalancerImpl.this.concurrency.get() == (long)oldConcurrency) {
                    for (InstanceState instanceState : HttpServiceBalancerImpl.this.uriStates.values()) {
                        if (oldConcurrency != instanceState.concurrency) continue;
                        return;
                    }
                    HttpServiceBalancerImpl.this.concurrency.update((long)(oldConcurrency - 1));
                }
            }
        }

        @Override
        public HttpServiceAttempt next() {
            Preconditions.checkState((!this.inProgress ? 1 : 0) != 0, (Object)"is not still in progress");
            ImmutableSet newAttempted = ImmutableSet.builder().add((Object)this.uri).addAll(this.attempted).build();
            return new HttpServiceAttemptImpl((Set<URI>)newAttempted);
        }
    }
}

