/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.client.balancing;

import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.primitives.Ints;
import com.proofpoint.units.Duration;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;

class LeakyTokenBucket {
    private final WindowedAdder windowedAdder;
    private final int reserve;

    LeakyTokenBucket(Duration ttl, int reserve, Ticker ticker) {
        this.windowedAdder = new WindowedAdder(ttl.roundTo(TimeUnit.NANOSECONDS), 10, ticker);
        this.reserve = reserve;
    }

    void put(int n) {
        Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0, (Object)"n must be non-negative");
        this.windowedAdder.add(n);
    }

    synchronized boolean tryGet(int n) {
        Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0, (Object)"n must be non-negative");
        if (this.count() < n) {
            return false;
        }
        this.windowedAdder.add(-n);
        return true;
    }

    private int count() {
        return Ints.checkedCast((long)(this.windowedAdder.sum() + (long)this.reserve));
    }

    private static class WindowedAdder {
        private final int window;
        private final int buckets;
        private final Ticker ticker;
        private final LongAdder writer = new LongAdder();
        private volatile int gen = 0;
        private final AtomicInteger expiredGen = new AtomicInteger(this.gen);
        private final long[] buf;
        private volatile int i = 0;
        private volatile long old;

        WindowedAdder(long range, int slices, Ticker ticker) {
            Preconditions.checkArgument((slices > 1 ? 1 : 0) != 0, (Object)"slices must be greater than one");
            this.window = Ints.checkedCast((long)(range / (long)slices));
            this.buckets = slices - 1;
            this.ticker = ticker;
            this.buf = new long[this.buckets];
            this.old = ticker.read();
        }

        public void add(int n) {
            if (this.ticker.read() - this.old >= (long)this.window) {
                this.expired();
            }
            this.writer.add(n);
        }

        public long sum() {
            if (this.ticker.read() - this.old >= (long)this.window) {
                this.expired();
            }
            int barrier = this.gen;
            long sum = this.writer.sum();
            for (int i = 0; i < this.buckets; ++i) {
                sum += this.buf[i];
            }
            return sum;
        }

        private void expired() {
            if (!this.expiredGen.compareAndSet(this.gen, this.gen + 1)) {
                return;
            }
            this.buf[this.i] = this.writer.sumThenReset();
            this.i = (this.i + 1) % this.buckets;
            int nSkip = Math.min(Ints.checkedCast((long)((this.ticker.read() - this.old) / (long)this.window - 1L)), this.buckets);
            if (nSkip > 0) {
                int r = Math.min(nSkip, this.buckets - this.i);
                Arrays.fill(this.buf, this.i, this.i + r, 0L);
                Arrays.fill(this.buf, 0, nSkip - r, 0L);
                this.i = (this.i + nSkip) % this.buckets;
            }
            this.old = this.ticker.read();
            ++this.gen;
        }
    }
}

