/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.client.balancing;

import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableSet;
import com.proofpoint.http.client.BodySource;
import com.proofpoint.http.client.LimitedRetryable;
import com.proofpoint.http.client.Request;
import com.proofpoint.http.client.Response;
import com.proofpoint.http.client.ResponseHandler;
import com.proofpoint.http.client.balancing.FailureStatusException;
import com.proofpoint.http.client.balancing.InnerHandlerException;
import com.proofpoint.http.client.balancing.RetryBudget;
import com.proofpoint.http.client.balancing.RetryException;
import com.proofpoint.log.Logger;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;

final class RetryingResponseHandler<T, E extends Exception>
implements ResponseHandler<T, RetryException> {
    private static final ImmutableSet<Integer> RETRYABLE_STATUS_CODES = ImmutableSet.of((Object)408, (Object)499, (Object)500, (Object)502, (Object)503, (Object)504, (Object[])new Integer[]{598, 599});
    private static final Logger log = Logger.get(RetryingResponseHandler.class);
    private final ResponseHandler<T, E> innerHandler;
    private final RetryBudget retryBudget;
    private final Cache<Class<? extends Exception>, Boolean> exceptionCache;

    RetryingResponseHandler(ResponseHandler<T, E> innerHandler, RetryBudget retryBudget, Cache<Class<? extends Exception>, Boolean> exceptionCache) {
        this.innerHandler = innerHandler;
        this.retryBudget = retryBudget;
        this.exceptionCache = exceptionCache;
    }

    @Override
    public T handleException(Request request, Exception exception) throws RetryException {
        AtomicBoolean isLogged = new AtomicBoolean(false);
        try {
            this.exceptionCache.get(exception.getClass(), () -> {
                log.warn((Throwable)exception, "Exception querying %s", new Object[]{request.getUri().resolve("/")});
                isLogged.set(true);
                return true;
            });
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        if (!isLogged.get()) {
            log.warn("Exception querying %s: %s", new Object[]{request.getUri().resolve("/"), exception});
        }
        if (!RetryingResponseHandler.bodySourceRetryable(request) || !this.retryBudget.canRetry()) {
            T result;
            try {
                result = this.innerHandler.handleException(request, exception);
            }
            catch (Exception e) {
                throw new InnerHandlerException(e, exception);
            }
            throw new FailureStatusException(result, exception);
        }
        throw new RetryException(exception);
    }

    @Override
    public T handle(Request request, Response response) throws RetryException {
        String failureCategory = response.getStatusCode() + " status code";
        if (RETRYABLE_STATUS_CODES.contains((Object)response.getStatusCode())) {
            T result;
            String retryHeader = response.getHeader("X-Proofpoint-Retry");
            log.warn("%d response querying %s", new Object[]{response.getStatusCode(), request.getUri().resolve("/")});
            if (!"no".equalsIgnoreCase(retryHeader) && RetryingResponseHandler.bodySourceRetryable(request) && this.retryBudget.canRetry()) {
                throw new RetryException(failureCategory);
            }
            try {
                result = this.innerHandler.handle(request, response);
            }
            catch (Exception e) {
                throw new InnerHandlerException(e, failureCategory);
            }
            throw new FailureStatusException(result, failureCategory);
        }
        try {
            return this.innerHandler.handle(request, response);
        }
        catch (Exception e) {
            throw new InnerHandlerException(e, failureCategory);
        }
    }

    private static boolean bodySourceRetryable(Request request) {
        BodySource bodySource = request.getBodySource();
        return !(bodySource instanceof LimitedRetryable) || ((LimitedRetryable)((Object)bodySource)).isRetryable();
    }
}

