/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.client.balancing;

import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.primitives.Ints;
import com.proofpoint.http.client.balancing.LeakyTokenBucket;
import com.proofpoint.http.client.balancing.NoRetryBudget;
import com.proofpoint.http.client.balancing.RetryBudget;
import com.proofpoint.stats.SparseCounterStat;
import com.proofpoint.units.Duration;
import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;
import org.weakref.jmx.Nested;

class TokenRetryBudget
implements RetryBudget {
    private static final BigDecimal SCALE_FACTOR = new BigDecimal(1000);
    private final int depositAmount;
    private final int withdrawalAmount;
    private final LeakyTokenBucket tokenBucket;
    private final SparseCounterStat retryBudgetExhausted = new SparseCounterStat();

    private TokenRetryBudget(BigDecimal retryBudgetRatio, Duration retryBudgetRatioPeriod, int retryBudgetMinPerSecond, Ticker ticker) {
        if (retryBudgetRatio.equals(BigDecimal.ZERO)) {
            this.depositAmount = 0;
            this.withdrawalAmount = 1;
        } else {
            this.depositAmount = SCALE_FACTOR.intValue();
            this.withdrawalAmount = SCALE_FACTOR.divide(retryBudgetRatio, 4).intValue();
        }
        int reserve = retryBudgetMinPerSecond * Ints.checkedCast((long)retryBudgetRatioPeriod.roundTo(TimeUnit.SECONDS)) * this.withdrawalAmount;
        this.tokenBucket = new LeakyTokenBucket(retryBudgetRatioPeriod, reserve, ticker);
    }

    static RetryBudget tokenRetryBudget(BigDecimal retryBudgetRatio, Duration retryBudgetRatioPeriod, int retryBudgetMinPerSecond, Ticker ticker) {
        Preconditions.checkArgument((retryBudgetRatio.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (Object)"retryBudgetRatio must be non-negative");
        Preconditions.checkArgument((retryBudgetRatio.compareTo(SCALE_FACTOR) <= 0 ? 1 : 0) != 0, (Object)("retryBudgetRatio must be no greater than " + SCALE_FACTOR));
        Preconditions.checkArgument((retryBudgetRatioPeriod.compareTo(new Duration(1.0, TimeUnit.SECONDS)) >= 0 ? 1 : 0) != 0, (Object)" retryBudgetRatioPeriod must be at least 1s");
        Preconditions.checkArgument((retryBudgetRatioPeriod.compareTo(new Duration(60.0, TimeUnit.SECONDS)) <= 0 ? 1 : 0) != 0, (Object)" retryBudgetRatioPeriod must be at most 60s");
        Preconditions.checkArgument((retryBudgetMinPerSecond >= 0 ? 1 : 0) != 0, (Object)"retryBudgetMinPerSecond must be non-negative");
        if (retryBudgetRatio.equals(BigDecimal.ZERO) && retryBudgetMinPerSecond == 0) {
            return NoRetryBudget.INSTANCE;
        }
        return new TokenRetryBudget(retryBudgetRatio, retryBudgetRatioPeriod, retryBudgetMinPerSecond, ticker);
    }

    @Override
    public void initialAttempt() {
        this.tokenBucket.put(this.depositAmount);
    }

    @Override
    public boolean canRetry() {
        if (this.tokenBucket.tryGet(this.withdrawalAmount)) {
            return true;
        }
        this.retryBudgetExhausted.add(1L);
        return false;
    }

    @Nested
    public SparseCounterStat getRetryBudgetExhausted() {
        return this.retryBudgetExhausted;
    }
}

