/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.client.jetty;

import com.proofpoint.http.client.InputStreamBodySource;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;

class BodySourceInputStream
extends InputStream {
    private final InputStream delegate;
    private final AtomicLong bytesWritten;

    BodySourceInputStream(InputStreamBodySource bodySource, AtomicLong bytesWritten) {
        this.delegate = bodySource.getInputStream();
        this.bytesWritten = bytesWritten;
    }

    @Override
    public int read() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = this.delegate.read(b);
        if (read > 0) {
            this.bytesWritten.addAndGet(read);
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.delegate.read(b, off, len);
        if (read > 0) {
            this.bytesWritten.addAndGet(read);
        }
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.delegate.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

