/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.client.jetty;

import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import com.proofpoint.http.client.DynamicBodySource;
import com.proofpoint.tracetoken.TraceToken;
import com.proofpoint.tracetoken.TraceTokenManager;
import com.proofpoint.tracetoken.TraceTokenScope;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.util.BlockingArrayQueue;

class DynamicBodySourceContentProvider
implements ContentProvider {
    private static final ByteBuffer INITIAL = ByteBuffer.allocate(0);
    private static final ByteBuffer DONE = ByteBuffer.allocate(0);
    private final DynamicBodySource dynamicBodySource;
    private final AtomicLong bytesWritten;
    private final TraceToken traceToken;

    DynamicBodySourceContentProvider(DynamicBodySource dynamicBodySource, AtomicLong bytesWritten) {
        this.dynamicBodySource = dynamicBodySource;
        this.bytesWritten = bytesWritten;
        this.traceToken = TraceTokenManager.getCurrentTraceToken();
    }

    public long getLength() {
        return this.dynamicBodySource.getLength();
    }

    public Iterator<ByteBuffer> iterator() {
        DynamicBodySource.Writer writer;
        BlockingArrayQueue chunks = new BlockingArrayQueue(4, 64);
        try (TraceTokenScope ignored = TraceTokenManager.registerTraceToken((TraceToken)this.traceToken);){
            writer = this.dynamicBodySource.start(new DynamicBodySourceOutputStream((Queue)chunks));
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        return new DynamicBodySourceIterator((Queue<ByteBuffer>)chunks, writer, this.bytesWritten, this.traceToken);
    }

    static /* synthetic */ ByteBuffer access$100() {
        return INITIAL;
    }

    private static class DynamicBodySourceIterator
    extends AbstractIterator<ByteBuffer>
    implements Closeable {
        private final Queue<ByteBuffer> chunks;
        private final DynamicBodySource.Writer writer;
        private final AtomicLong bytesWritten;
        private final TraceToken traceToken;

        DynamicBodySourceIterator(Queue<ByteBuffer> chunks, DynamicBodySource.Writer writer, AtomicLong bytesWritten, TraceToken traceToken) {
            this.chunks = chunks;
            this.writer = writer;
            this.bytesWritten = bytesWritten;
            this.traceToken = traceToken;
        }

        protected ByteBuffer computeNext() {
            ByteBuffer chunk = this.chunks.poll();
            if (chunk == null) {
                try (TraceTokenScope ignored = TraceTokenManager.registerTraceToken((TraceToken)this.traceToken);){
                    while (chunk == null) {
                        try {
                            this.writer.write();
                        }
                        catch (Exception e) {
                            Throwables.throwIfUnchecked((Throwable)e);
                            throw new RuntimeException(e);
                        }
                        chunk = this.chunks.poll();
                    }
                }
            }
            if (chunk == DONE) {
                return (ByteBuffer)this.endOfData();
            }
            this.bytesWritten.addAndGet(chunk.position());
            ((Buffer)chunk).flip();
            return chunk;
        }

        @Override
        public void close() {
            if (this.writer instanceof AutoCloseable) {
                try (TraceTokenScope ignored = TraceTokenManager.registerTraceToken((TraceToken)this.traceToken);){
                    ((AutoCloseable)((Object)this.writer)).close();
                }
                catch (Exception e) {
                    Throwables.throwIfUnchecked((Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static class DynamicBodySourceOutputStream
    extends OutputStream {
        private static int BUFFER_SIZE = 4096;
        private ByteBuffer lastChunk = DynamicBodySourceContentProvider.access$100();
        private final Queue<ByteBuffer> chunks;

        private DynamicBodySourceOutputStream(Queue<ByteBuffer> chunks) {
            this.chunks = chunks;
        }

        @Override
        public void write(int b) {
            if (!this.chunks.isEmpty() && this.lastChunk.hasRemaining()) {
                this.lastChunk.put((byte)b);
            } else {
                this.lastChunk = ByteBuffer.allocate(BUFFER_SIZE);
                this.lastChunk.put((byte)b);
                this.chunks.add(this.lastChunk);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) {
            if (!this.chunks.isEmpty() && this.lastChunk.hasRemaining()) {
                int toCopy = Math.min(len, this.lastChunk.remaining());
                this.lastChunk.put(b, off, toCopy);
                if (toCopy == len) {
                    return;
                }
                off += toCopy;
                len -= toCopy;
            }
            this.lastChunk = ByteBuffer.allocate(Math.max(BUFFER_SIZE, len));
            this.lastChunk.put(b, off, len);
            this.chunks.add(this.lastChunk);
        }

        @Override
        public void close() {
            this.lastChunk = DONE;
            this.chunks.add(DONE);
        }
    }
}

