/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.client.jetty;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.io.Closeables;
import com.google.common.net.HostAndPort;
import com.google.common.primitives.Ints;
import com.proofpoint.http.client.BodySource;
import com.proofpoint.http.client.DynamicBodySource;
import com.proofpoint.http.client.HttpClient;
import com.proofpoint.http.client.HttpClientConfig;
import com.proofpoint.http.client.HttpRequestFilter;
import com.proofpoint.http.client.InputStreamBodySource;
import com.proofpoint.http.client.Request;
import com.proofpoint.http.client.RequestStats;
import com.proofpoint.http.client.ResponseHandler;
import com.proofpoint.http.client.StaticBodyGenerator;
import com.proofpoint.http.client.jetty.AuthorizationPreservingHttpClient;
import com.proofpoint.http.client.jetty.BufferingResponseListener;
import com.proofpoint.http.client.jetty.CachedDistribution;
import com.proofpoint.http.client.jetty.ConcurrentScheduler;
import com.proofpoint.http.client.jetty.ConnectionPoolDistribution;
import com.proofpoint.http.client.jetty.DestinationDistribution;
import com.proofpoint.http.client.jetty.DynamicBodySourceContentProvider;
import com.proofpoint.http.client.jetty.InputStreamBodySourceContentProvider;
import com.proofpoint.http.client.jetty.IoPoolStats;
import com.proofpoint.http.client.jetty.JettyAsyncSocketAddressResolver;
import com.proofpoint.http.client.jetty.JettyLogging;
import com.proofpoint.http.client.jetty.JettyRequestListener;
import com.proofpoint.http.client.jetty.JettyResponse;
import com.proofpoint.http.client.jetty.JettyResponseFuture;
import com.proofpoint.http.client.jetty.RequestDistribution;
import com.proofpoint.http.client.jetty.Stats;
import com.proofpoint.log.Logger;
import com.proofpoint.units.Duration;
import java.io.InputStream;
import java.net.CookieStore;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.eclipse.jetty.client.DuplexConnectionPool;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.PoolingHttpDestination;
import org.eclipse.jetty.client.Socks4Proxy;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Destination;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.http.HttpClientTransportOverHTTP;
import org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.http.HttpClientTransportOverHTTP2;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.util.HttpCookieStore;
import org.eclipse.jetty.util.SocketAddressResolver;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.Sweeper;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class JettyHttpClient
implements HttpClient {
    private static final Logger log;
    private static final String[] ENABLED_PROTOCOLS;
    private static final String[] ENABLED_CIPHERS;
    private static final String PLATFORM_STATS_KEY = "platform_stats";
    private static final long SWEEP_PERIOD_MILLIS = 5000L;
    private static final AtomicLong NAME_COUNTER;
    private final org.eclipse.jetty.client.HttpClient httpClient;
    private final long maxContentLength;
    private final Long requestTimeoutMillis;
    private final long idleTimeoutMillis;
    private final Stats stats;
    private final CachedDistribution queuedRequestsPerDestination;
    private final CachedDistribution activeConnectionsPerDestination;
    private final CachedDistribution idleConnectionsPerDestination;
    private final CachedDistribution currentQueuedTime;
    private final CachedDistribution currentRequestTime;
    private final CachedDistribution currentRequestSendTime;
    private final CachedDistribution currentResponseWaitTime;
    private final CachedDistribution currentResponseProcessTime;
    private final List<HttpRequestFilter> requestFilters;
    private final Exception creationLocation = new Exception();
    private final String name;
    private final AtomicLong lastLoggedJettyState = new AtomicLong();

    public JettyHttpClient() {
        this(new HttpClientConfig());
    }

    public JettyHttpClient(HttpClientConfig config) {
        this(JettyHttpClient.uniqueName(), config);
    }

    public JettyHttpClient(String name, HttpClientConfig config) {
        this(name, config, (Iterable<? extends HttpRequestFilter>)ImmutableList.of());
    }

    public JettyHttpClient(String name, HttpClientConfig config, Iterable<? extends HttpRequestFilter> requestFilters) {
        HostAndPort socksProxy;
        HttpClientTransportOverHTTP transport;
        this.name = Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(requestFilters, "requestFilters is null");
        this.maxContentLength = config.getMaxContentLength().toBytes();
        Duration requestTimeout = config.getRequestTimeout();
        this.requestTimeoutMillis = requestTimeout == null ? null : Long.valueOf(requestTimeout.toMillis());
        this.idleTimeoutMillis = config.getIdleTimeout().toMillis();
        this.creationLocation.fillInStackTrace();
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setEndpointIdentificationAlgorithm("HTTPS");
        sslContextFactory.setExcludeProtocols(new String[0]);
        sslContextFactory.setIncludeProtocols(ENABLED_PROTOCOLS);
        sslContextFactory.setExcludeCipherSuites(new String[0]);
        sslContextFactory.setIncludeCipherSuites(ENABLED_CIPHERS);
        sslContextFactory.setCipherComparator((Comparator)Ordering.explicit((Object)"", (Object[])ENABLED_CIPHERS));
        if (config.getKeyStorePath() != null) {
            sslContextFactory.setKeyStorePath(config.getKeyStorePath());
            sslContextFactory.setKeyStorePassword(config.getKeyStorePassword());
        }
        if (config.getTrustStorePath() != null) {
            sslContextFactory.setTrustStorePath(config.getTrustStorePath());
            sslContextFactory.setTrustStorePassword(config.getTrustStorePassword());
        }
        if (config.isHttp2Enabled()) {
            HTTP2Client client = new HTTP2Client();
            client.setInitialSessionRecvWindow(Math.toIntExact(config.getHttp2InitialSessionReceiveWindowSize().toBytes()));
            client.setInitialStreamRecvWindow(Math.toIntExact(config.getHttp2InitialStreamReceiveWindowSize().toBytes()));
            client.setInputBufferSize(Math.toIntExact(config.getHttp2InputBufferSize().toBytes()));
            client.setSelectors(config.getSelectorCount());
            transport = new HttpClientTransportOverHTTP2(client);
        } else {
            transport = new HttpClientTransportOverHTTP(config.getSelectorCount());
        }
        this.httpClient = new AuthorizationPreservingHttpClient((HttpClientTransport)transport, sslContextFactory);
        this.httpClient.setRequestBufferSize(Math.toIntExact(config.getRequestBufferSize().toBytes()));
        this.httpClient.setResponseBufferSize(Math.toIntExact(config.getResponseBufferSize().toBytes()));
        this.httpClient.setMaxRequestsQueuedPerDestination(config.getMaxRequestsQueuedPerDestination());
        this.httpClient.setMaxConnectionsPerDestination(config.getMaxConnectionsPerServer());
        this.httpClient.setCookieStore((CookieStore)new HttpCookieStore.Empty());
        this.httpClient.setUserAgentField(null);
        this.httpClient.setIdleTimeout(this.idleTimeoutMillis);
        this.httpClient.setConnectTimeout(config.getConnectTimeout().toMillis());
        this.httpClient.setAddressResolutionTimeout(config.getConnectTimeout().toMillis());
        if (config.getConnectTimeout() != null) {
            long connectTimeout = config.getConnectTimeout().toMillis();
            this.httpClient.setConnectTimeout(connectTimeout);
            this.httpClient.setAddressResolutionTimeout(connectTimeout);
        }
        if ((socksProxy = config.getSocksProxy()) != null) {
            this.httpClient.getProxyConfiguration().getProxies().add(new Socks4Proxy(socksProxy.getHost(), socksProxy.getPortOrDefault(1080)));
        }
        this.httpClient.setByteBufferPool((ByteBufferPool)new MappedByteBufferPool());
        QueuedThreadPool executor = JettyHttpClient.createExecutor(name, config.getMinThreads(), config.getMaxThreads());
        this.stats = Stats.stats(executor);
        this.httpClient.setExecutor((Executor)executor);
        this.httpClient.addBean((Object)executor, true);
        this.httpClient.setScheduler(JettyHttpClient.createScheduler(name, config.getTimeoutConcurrency(), config.getTimeoutThreads()));
        this.httpClient.setSocketAddressResolver((SocketAddressResolver)new JettyAsyncSocketAddressResolver(this.httpClient.getExecutor(), this.httpClient.getScheduler(), config.getConnectTimeout().toMillis()));
        this.httpClient.setSocketAddressResolver((SocketAddressResolver)new JettyAsyncSocketAddressResolver(this.httpClient.getExecutor(), this.httpClient.getScheduler(), config.getConnectTimeout().toMillis()));
        this.httpClient.addBean((Object)new Sweeper(this.httpClient.getScheduler(), 5000L), true);
        try {
            this.httpClient.start();
            this.httpClient.getContentDecoderFactories().clear();
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        this.requestFilters = ImmutableList.copyOf(requestFilters);
        this.activeConnectionsPerDestination = new ConnectionPoolDistribution(this.httpClient, (distribution, connectionPool) -> distribution.add((long)connectionPool.getActiveConnections().size()));
        this.idleConnectionsPerDestination = new ConnectionPoolDistribution(this.httpClient, (distribution, connectionPool) -> distribution.add((long)connectionPool.getIdleConnections().size()));
        this.queuedRequestsPerDestination = new DestinationDistribution(this.httpClient, (distribution, destination) -> distribution.add((long)destination.getHttpExchanges().size()));
        this.currentQueuedTime = new RequestDistribution(this.httpClient, (distribution, listener, now) -> {
            long started = listener.getRequestStarted();
            if (started == 0L) {
                started = now;
            }
            distribution.add(TimeUnit.NANOSECONDS.toMillis(started - listener.getCreated()));
        });
        this.currentRequestTime = new RequestDistribution(this.httpClient, (distribution, listener, now) -> {
            long started = listener.getRequestStarted();
            if (started == 0L) {
                return;
            }
            long finished = listener.getResponseFinished();
            if (finished == 0L) {
                finished = now;
            }
            distribution.add(TimeUnit.NANOSECONDS.toMillis(finished - started));
        });
        this.currentRequestSendTime = new RequestDistribution(this.httpClient, (distribution, listener, now) -> {
            long started = listener.getRequestStarted();
            if (started == 0L) {
                return;
            }
            long requestSent = listener.getRequestFinished();
            if (requestSent == 0L) {
                requestSent = now;
            }
            distribution.add(TimeUnit.NANOSECONDS.toMillis(requestSent - started));
        });
        this.currentResponseWaitTime = new RequestDistribution(this.httpClient, (distribution, listener, now) -> {
            long requestSent = listener.getRequestFinished();
            if (requestSent == 0L) {
                return;
            }
            long responseStarted = listener.getResponseStarted();
            if (responseStarted == 0L) {
                responseStarted = now;
            }
            distribution.add(TimeUnit.NANOSECONDS.toMillis(responseStarted - requestSent));
        });
        this.currentResponseProcessTime = new RequestDistribution(this.httpClient, (distribution, listener, now) -> {
            long responseStarted = listener.getResponseStarted();
            if (responseStarted == 0L) {
                return;
            }
            long finished = listener.getResponseFinished();
            if (finished == 0L) {
                finished = now;
            }
            distribution.add(TimeUnit.NANOSECONDS.toMillis(finished - responseStarted));
        });
    }

    private static QueuedThreadPool createExecutor(String name, int minThreads, int maxThreads) {
        try {
            QueuedThreadPool pool = new QueuedThreadPool(maxThreads, minThreads, 60000, null);
            pool.setName("http-client-" + name);
            pool.setDaemon(true);
            pool.start();
            pool.setStopTimeout(2000L);
            return pool;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static Scheduler createScheduler(String name, int timeoutConcurrency, int timeoutThreads) {
        Object scheduler;
        String threadName = "http-client-" + name + "-scheduler";
        if (timeoutConcurrency == 1 && timeoutThreads == 1) {
            scheduler = new ScheduledExecutorScheduler(threadName, true);
        } else {
            Preconditions.checkArgument((timeoutConcurrency >= 1 ? 1 : 0) != 0, (Object)"timeoutConcurrency must be at least one");
            int threads = Math.max(1, timeoutThreads / timeoutConcurrency);
            scheduler = new ConcurrentScheduler(timeoutConcurrency, threads, threadName);
        }
        try {
            scheduler.start();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        return scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Exception> T execute(Request request, ResponseHandler<T, E> responseHandler) throws E {
        T value;
        Response response;
        long requestStart = System.nanoTime();
        AtomicLong bytesWritten = new AtomicLong(0L);
        request = this.applyRequestFilters(request);
        HttpRequest jettyRequest = this.buildJettyRequest(request, bytesWritten);
        InputStreamResponseListener listener = new InputStreamResponseListener(){

            public void onContent(Response response, ByteBuffer content) {
                if (content.remaining() == 0) {
                    return;
                }
                super.onContent(response, content);
            }
        };
        jettyRequest.send((Response.CompleteListener)listener);
        try {
            response = listener.get(this.httpClient.getIdleTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            jettyRequest.abort((Throwable)e);
            Thread.currentThread().interrupt();
            return responseHandler.handleException(request, e);
        }
        catch (TimeoutException e) {
            jettyRequest.abort((Throwable)e);
            return responseHandler.handleException(request, e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RejectedExecutionException || cause instanceof ClosedByInterruptException) {
                this.maybeLogJettyState();
            }
            if (cause instanceof Exception) {
                return responseHandler.handleException(request, (Exception)cause);
            }
            if (cause instanceof NoClassDefFoundError && cause.getMessage().endsWith("ALPNClientConnection")) {
                return responseHandler.handleException(request, new RuntimeException("HTTPS cannot be used when HTTP/2 is enabled", cause));
            }
            return responseHandler.handleException(request, new RuntimeException(cause));
        }
        long responseStart = System.nanoTime();
        JettyResponse jettyResponse = null;
        try {
            InputStream inputStream = listener.getInputStream();
            try {
                jettyResponse = new JettyResponse(response, inputStream);
                value = responseHandler.handle(request, jettyResponse);
            }
            finally {
                Closeables.closeQuietly((InputStream)inputStream);
            }
        }
        finally {
            JettyHttpClient.recordRequestComplete(this.stats, request, requestStart, bytesWritten.get(), jettyResponse, responseStart);
        }
        return value;
    }

    void maybeLogJettyState() {
        long time;
        long lastLogged = this.lastLoggedJettyState.get();
        if (lastLogged + 60000000000L > (time = System.nanoTime())) {
            return;
        }
        if (this.lastLoggedJettyState.compareAndSet(lastLogged, time)) {
            log.warn("Received RejectedExecutionException. Jetty dump:\n%s", new Object[]{this.dump()});
        }
    }

    @Override
    public <T, E extends Exception> HttpClient.HttpResponseFuture<T> executeAsync(Request request, ResponseHandler<T, E> responseHandler) {
        Objects.requireNonNull(request, "request is null");
        Objects.requireNonNull(responseHandler, "responseHandler is null");
        AtomicLong bytesWritten = new AtomicLong(0L);
        request = this.applyRequestFilters(request);
        HttpRequest jettyRequest = this.buildJettyRequest(request, bytesWritten);
        JettyResponseFuture<T, E> future = new JettyResponseFuture<T, E>(this, request, (org.eclipse.jetty.client.api.Request)jettyRequest, responseHandler, bytesWritten, this.stats);
        BufferingResponseListener listener = new BufferingResponseListener(future, Ints.saturatedCast((long)this.maxContentLength));
        try {
            jettyRequest.send((Response.CompleteListener)listener);
        }
        catch (RuntimeException e2) {
            RejectedExecutionException e2;
            if (!(e2 instanceof RejectedExecutionException)) {
                e2 = new RejectedExecutionException(e2);
            }
            future.failed(e2);
        }
        return future;
    }

    private Request applyRequestFilters(Request request) {
        for (HttpRequestFilter requestFilter : this.requestFilters) {
            request = requestFilter.filterRequest(request);
        }
        return request;
    }

    private HttpRequest buildJettyRequest(Request finalRequest, AtomicLong bytesWritten) {
        HttpRequest jettyRequest = (HttpRequest)this.httpClient.newRequest(finalRequest.getUri());
        JettyRequestListener listener = new JettyRequestListener(finalRequest.getUri());
        jettyRequest.onRequestBegin(request -> listener.onRequestBegin());
        jettyRequest.onRequestSuccess(request -> listener.onRequestEnd());
        jettyRequest.onResponseBegin(response -> listener.onResponseBegin());
        jettyRequest.onComplete(result -> listener.onFinish());
        jettyRequest.attribute(PLATFORM_STATS_KEY, (Object)listener);
        jettyRequest.method(finalRequest.getMethod());
        for (Map.Entry entry : finalRequest.getHeaders().entries()) {
            jettyRequest.header((String)entry.getKey(), (String)entry.getValue());
        }
        BodySource bodySource = finalRequest.getBodySource();
        if (bodySource != null) {
            if (bodySource instanceof StaticBodyGenerator) {
                StaticBodyGenerator staticBodyGenerator = (StaticBodyGenerator)bodySource;
                jettyRequest.content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{staticBodyGenerator.getBody()}));
                bytesWritten.addAndGet(staticBodyGenerator.getBody().length);
            } else if (bodySource instanceof InputStreamBodySource) {
                jettyRequest.content((ContentProvider)new InputStreamBodySourceContentProvider((InputStreamBodySource)bodySource, bytesWritten));
            } else if (bodySource instanceof DynamicBodySource) {
                jettyRequest.content((ContentProvider)new DynamicBodySourceContentProvider((DynamicBodySource)bodySource, bytesWritten));
            } else {
                throw new IllegalArgumentException("Request has unsupported BodySource type");
            }
        }
        jettyRequest.followRedirects(finalRequest.isFollowRedirects());
        AuthorizationPreservingHttpClient.setPreserveAuthorization((org.eclipse.jetty.client.api.Request)jettyRequest, finalRequest.isPreserveAuthorizationOnRedirect());
        if (this.requestTimeoutMillis != null) {
            jettyRequest.timeout(this.requestTimeoutMillis.longValue(), TimeUnit.MILLISECONDS);
        }
        jettyRequest.idleTimeout(this.idleTimeoutMillis, TimeUnit.MILLISECONDS);
        return jettyRequest;
    }

    public List<HttpRequestFilter> getRequestFilters() {
        return this.requestFilters;
    }

    @Deprecated
    public IoPoolStats getIoPoolStats() {
        return this.stats.getIoPool();
    }

    @Override
    @Managed
    @Flatten
    public RequestStats getStats() {
        return this.stats;
    }

    @Managed
    @Nested
    public CachedDistribution getActiveConnectionsPerDestination() {
        return this.activeConnectionsPerDestination;
    }

    @Managed
    @Nested
    public CachedDistribution getIdleConnectionsPerDestination() {
        return this.idleConnectionsPerDestination;
    }

    @Managed
    @Nested
    public CachedDistribution getQueuedRequestsPerDestination() {
        return this.queuedRequestsPerDestination;
    }

    @Managed
    @Nested
    public CachedDistribution getCurrentQueuedTime() {
        return this.currentQueuedTime;
    }

    @Managed
    @Nested
    public CachedDistribution getCurrentRequestTime() {
        return this.currentRequestTime;
    }

    @Managed
    @Nested
    public CachedDistribution getCurrentRequestSendTime() {
        return this.currentRequestSendTime;
    }

    @Managed
    @Nested
    public CachedDistribution getCurrentResponseWaitTime() {
        return this.currentResponseWaitTime;
    }

    @Managed
    @Nested
    public CachedDistribution getCurrentResponseProcessTime() {
        return this.currentResponseProcessTime;
    }

    @Managed
    public String dump() {
        return this.httpClient.dump();
    }

    @Managed
    public void dumpStdErr() {
        this.httpClient.dumpStdErr();
    }

    @Managed
    public String dumpAllDestinations() {
        return String.format("%s\t%s\t%s\t%s\t%s%n", "URI", "queued", "request", "wait", "response") + this.httpClient.getDestinations().stream().map(JettyHttpClient::dumpDestination).collect(Collectors.joining("\n"));
    }

    public String dumpDestination(URI uri) {
        Destination destination = this.httpClient.getDestination(uri.getScheme(), uri.getHost(), uri.getPort());
        if (destination == null) {
            return null;
        }
        return JettyHttpClient.dumpDestination(destination);
    }

    private static String dumpDestination(Destination destination) {
        long now = System.nanoTime();
        return JettyHttpClient.getRequestListenersForDestination(destination).stream().map(listener -> JettyHttpClient.dumpRequest(now, listener)).sorted().collect(Collectors.joining("\n"));
    }

    static List<JettyRequestListener> getRequestListenersForDestination(Destination destination) {
        return JettyHttpClient.getRequestForDestination(destination).stream().map(request -> request.getAttributes().get(PLATFORM_STATS_KEY)).map(JettyRequestListener.class::cast).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static List<org.eclipse.jetty.client.api.Request> getRequestForDestination(Destination destination) {
        PoolingHttpDestination poolingHttpDestination = (PoolingHttpDestination)destination;
        Queue httpExchanges = poolingHttpDestination.getHttpExchanges();
        List requests = httpExchanges.stream().map(HttpExchange::getRequest).collect(Collectors.toList());
        ((DuplexConnectionPool)poolingHttpDestination.getConnectionPool()).getActiveConnections().stream().filter(HttpConnectionOverHTTP.class::isInstance).map(HttpConnectionOverHTTP.class::cast).map(connection -> connection.getHttpChannel().getHttpExchange()).filter(Objects::nonNull).forEach(exchange -> requests.add(exchange.getRequest()));
        return (List)requests.stream().filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
    }

    private static String dumpRequest(long now, JettyRequestListener listener) {
        long finished;
        long responseStarted;
        long requestFinished;
        long created = listener.getCreated();
        long requestStarted = listener.getRequestStarted();
        if (requestStarted == 0L) {
            requestStarted = now;
        }
        if ((requestFinished = listener.getRequestFinished()) == 0L) {
            requestFinished = now;
        }
        if ((responseStarted = listener.getResponseStarted()) == 0L) {
            responseStarted = now;
        }
        if ((finished = listener.getResponseFinished()) == 0L) {
            finished = now;
        }
        return String.format("%s\t%.1f\t%.1f\t%.1f\t%.1f", listener.getUri(), JettyHttpClient.nanosToMillis(requestStarted - created), JettyHttpClient.nanosToMillis(requestFinished - requestStarted), JettyHttpClient.nanosToMillis(responseStarted - requestFinished), JettyHttpClient.nanosToMillis(finished - responseStarted));
    }

    private static double nanosToMillis(long nanos) {
        return new Duration((double)nanos, TimeUnit.NANOSECONDS).getValue(TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        JettyHttpClient.closeQuietly((LifeCycle)this.httpClient);
        JettyHttpClient.closeQuietly((LifeCycle)this.httpClient.getExecutor());
        JettyHttpClient.closeQuietly((LifeCycle)this.httpClient.getScheduler());
    }

    @Override
    public boolean isClosed() {
        return !this.httpClient.isRunning();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.name).toString();
    }

    public StackTraceElement[] getCreationLocation() {
        return this.creationLocation.getStackTrace();
    }

    private static void closeQuietly(LifeCycle service) {
        try {
            if (service != null) {
                service.stop();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String uniqueName() {
        return "anonymous" + NAME_COUNTER.incrementAndGet();
    }

    static void recordRequestComplete(RequestStats requestStats, Request request, long requestStart, long bytesWritten, JettyResponse response, long responseStart) {
        if (response == null) {
            return;
        }
        Duration responseProcessingTime = Duration.nanosSince((long)responseStart);
        Duration requestProcessingTime = new Duration((double)(responseStart - requestStart), TimeUnit.NANOSECONDS);
        requestStats.record(request.getMethod(), response.getStatusCode(), bytesWritten, response.getBytesRead(), requestProcessingTime, responseProcessingTime);
    }

    static {
        String[] stringArray;
        JettyLogging.setup();
        log = Logger.get(JettyHttpClient.class);
        if (System.getProperty("java.version").matches("11(\\.0\\.[12])?")) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "TLSv1.1";
            stringArray = stringArray2;
            stringArray2[1] = "TLSv1.2";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "TLSv1.1";
            stringArray3[1] = "TLSv1.2";
            stringArray = stringArray3;
            stringArray3[2] = "TLSv1.3";
        }
        ENABLED_PROTOCOLS = stringArray;
        ENABLED_CIPHERS = new String[]{"TLS_AES_256_GCM_SHA384", "TLS_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_EMPTY_RENEGOTIATION_INFO_SCSV"};
        NAME_COUNTER = new AtomicLong();
    }
}

